/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.ActivationManager;
import org.evrete.api.ActivationMode;
import org.evrete.api.Evaluator;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.ExpressionResolver;
import org.evrete.api.FieldReference;
import org.evrete.api.JavaSourceCompiler;
import org.evrete.api.LiteralEvaluator;
import org.evrete.api.LiteralExpression;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.api.RuleBuilder;
import org.evrete.api.RuleCompiledSources;
import org.evrete.api.RuleLiteralData;
import org.evrete.api.RuleSetContext;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeField;
import org.evrete.api.TypeResolver;
import org.evrete.api.builders.RuleSetBuilder;
import org.evrete.runtime.DefaultLhsBuilder;
import org.evrete.runtime.DefaultRuleBuilder;
import org.evrete.runtime.DefaultRuleLiteralData;
import org.evrete.runtime.DefaultRuleSetBuilder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.JustConditionsRuleData;
import org.evrete.runtime.JustRhsRuleData;
import org.evrete.runtime.LhsConditionHandles;
import org.evrete.runtime.LhsConditions;
import org.evrete.runtime.RuleBuilderImpl;
import org.evrete.runtime.RuleDescriptor;
import org.evrete.runtime.RuntimeMetaData;
import org.evrete.runtime.async.ForkJoinExecutor;
import org.evrete.runtime.compiler.CompilationException;
import org.evrete.runtime.compiler.RuntimeClassloader;
import org.evrete.runtime.compiler.SourceCompiler;
import org.evrete.runtime.evaluation.MemoryAddress;
import org.evrete.util.DefaultActivationManager;
import org.evrete.util.WorkUnitObject;

public abstract class AbstractRuntime<R extends Rule, C extends RuntimeContext<C>>
extends RuntimeMetaData<C>
implements RuleSetContext<C, R> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuntime.class.getName());
    private final KnowledgeService service;
    private final Configuration configuration;
    private final AtomicInteger noNameRuleCounter;
    private ExpressionResolver expressionResolver;
    private Comparator<Rule> ruleComparator = SALIENCE_COMPARATOR;
    private Class<? extends ActivationManager> activationManagerFactory;
    private ActivationMode agendaMode;
    private RuntimeClassloader classloader;

    AbstractRuntime(KnowledgeService service, TypeResolver typeResolver) {
        super(service, typeResolver);
        this.configuration = service.getConfiguration().copyOf();
        this.classloader = new RuntimeClassloader(service.getClassLoader());
        this.service = service;
        this.activationManagerFactory = DefaultActivationManager.class;
        this.agendaMode = ActivationMode.DEFAULT;
        this.noNameRuleCounter = new AtomicInteger();
    }

    AbstractRuntime(KnowledgeService service) {
        this(service, service.newTypeResolver());
    }

    AbstractRuntime(AbstractRuntime<?, ?> parent) {
        super(parent);
        this.configuration = parent.configuration.copyOf();
        this.service = parent.service;
        this.ruleComparator = parent.ruleComparator;
        this.activationManagerFactory = parent.activationManagerFactory;
        this.agendaMode = parent.agendaMode;
        this.expressionResolver = null;
        this.noNameRuleCounter = parent.noNameRuleCounter;
        this.classloader = new RuntimeClassloader(parent.classloader);
    }

    abstract void addRuleDescriptors(List<RuleDescriptor> var1);

    ActivationMode getAgendaMode() {
        return this.agendaMode;
    }

    void addRules(List<DefaultRuleBuilder<C>> rules) {
        List<RuleDescriptor> descriptors = this.compileRuleBuilders(rules);
        this.addRuleDescriptors(descriptors);
    }

    @Override
    public final RuntimeClassloader getClassLoader() {
        return this.classloader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classloader = new RuntimeClassloader(classLoader);
    }

    @Override
    public final JavaSourceCompiler getSourceCompiler() {
        return new SourceCompiler(this.classloader);
    }

    @Override
    public C setActivationMode(ActivationMode activationMode) {
        this._assertActive();
        this.agendaMode = activationMode;
        return (C)this;
    }

    @Override
    public KnowledgeService getService() {
        this._assertActive();
        return this.service;
    }

    @Override
    public Class<? extends ActivationManager> getActivationManagerFactory() {
        this._assertActive();
        return this.activationManagerFactory;
    }

    @Override
    public <A extends ActivationManager> void setActivationManagerFactory(Class<A> managerClass) {
        this._assertActive();
        this.activationManagerFactory = managerClass;
    }

    @Override
    public final void setActivationManagerFactory(String managerClass) {
        this._assertActive();
        try {
            Class<?> factory = Class.forName(managerClass, true, this.getClassLoader());
            this.setActivationManagerFactory(factory);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(managerClass);
        }
    }

    ActivationManager newActivationManager() {
        try {
            return this.activationManagerFactory.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create activation manager. Probably the provided factory class has no public and zero-argument constructor.", e);
        }
    }

    @Override
    public Comparator<Rule> getRuleComparator() {
        return this.ruleComparator;
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        this._assertActive();
        this.ruleComparator = ruleComparator;
    }

    ForkJoinExecutor getExecutor() {
        this._assertActive();
        return this.service.getExecutor();
    }

    FactType buildFactType(NamedType builder, Set<TypeField> fields, Set<EvaluatorHandle> alphaEvaluators, int inRuleId) {
        this._assertActive();
        MemoryAddress memoryAddress = this.buildMemoryAddress(builder.getType(), fields, alphaEvaluators);
        return new FactType(builder.getName(), memoryAddress, inRuleId);
    }

    @Override
    @Deprecated
    public RuleBuilder<C> newRule() {
        return this.newRule(this.unnamedRuleName());
    }

    String unnamedRuleName() {
        return "rule_" + this.noNameRuleCounter.incrementAndGet();
    }

    @Override
    @Deprecated
    public RuleBuilder<C> newRule(String name) {
        this._assertActive();
        return new RuleBuilderImpl(this, name);
    }

    @Override
    public RuleSetBuilder<C> builder() {
        this._assertActive();
        return new DefaultRuleSetBuilder(this);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    synchronized List<RuleDescriptor> compileRuleBuilders(List<DefaultRuleBuilder<C>> rules) {
        List ruleLiteralSources = rules.stream().map(DefaultRuleLiteralData::new).filter(DefaultRuleLiteralData::nonEmpty).collect(Collectors.toList());
        try {
            return this.compileRuleBuilders(rules, this.compileRules(ruleLiteralSources));
        }
        catch (CompilationException e) {
            e.log(LOGGER, Level.WARNING);
            throw new RuntimeException(e);
        }
    }

    private List<RuleDescriptor> compileRuleBuilders(List<DefaultRuleBuilder<C>> rules, Collection<RuleCompiledSources<DefaultRuleLiteralData, DefaultRuleBuilder<?>>> compiled) {
        int currentRuleCount = this.getRules().size();
        IdentityHashMap mapping = new IdentityHashMap();
        for (RuleCompiledSources<DefaultRuleLiteralData, DefaultRuleBuilder<?>> entry : compiled) {
            DefaultRuleBuilder<C> ruleBuilder = entry.getSources().getRule();
            mapping.put(ruleBuilder, entry);
        }
        ArrayList<RuleDescriptor> descriptors = new ArrayList<RuleDescriptor>(rules.size());
        for (DefaultRuleBuilder<C> ruleBuilder : rules) {
            String string;
            if (this.ruleExists(ruleBuilder.getName())) {
                throw new IllegalArgumentException("Rule '" + ruleBuilder.getName() + "' already exists");
            }
            int salience = ruleBuilder.getSalience();
            if (salience == Integer.MIN_VALUE) {
                salience = -1 * (currentRuleCount + 1);
            }
            LhsConditionHandles handles = new LhsConditionHandles();
            LhsConditions builderConditions = ((DefaultLhsBuilder)ruleBuilder.getLhs()).getConditions();
            for (EvaluatorHandle evaluatorHandle : builderConditions.directHandles) {
                handles.add(evaluatorHandle);
            }
            for (WorkUnitObject workUnitObject : builderConditions.evaluators) {
                EvaluatorHandle handle = this.addEvaluator((Evaluator)workUnitObject.getDelegate(), workUnitObject.getComplexity());
                handles.add(handle);
            }
            Collection<WorkUnitObject<String>> literalConditions = builderConditions.literals;
            if (!literalConditions.isEmpty()) {
                RuleCompiledSources ruleCompiledSources = (RuleCompiledSources)mapping.get(ruleBuilder);
                if (ruleCompiledSources == null) {
                    throw new IllegalStateException("No compiled data for literal sources");
                }
                IdentityHashMap<String, LiteralEvaluator> conditionMap = new IdentityHashMap<String, LiteralEvaluator>();
                for (LiteralEvaluator literalEvaluator : ruleCompiledSources.conditions()) {
                    conditionMap.put(literalEvaluator.getSource().getSource(), literalEvaluator);
                }
                for (WorkUnitObject workUnitObject : literalConditions) {
                    String expression = (String)workUnitObject.getDelegate();
                    double complexity = workUnitObject.getComplexity();
                    LiteralEvaluator evaluator = (LiteralEvaluator)conditionMap.get(expression);
                    if (evaluator == null) {
                        throw new IllegalStateException("Compiled condition not found for " + expression);
                    }
                    EvaluatorHandle handle = this.addEvaluator(evaluator, complexity);
                    handles.add(handle);
                }
            }
            if ((string = ruleBuilder.getLiteralRhs()) != null) {
                RuleCompiledSources compiledData = (RuleCompiledSources)mapping.get(ruleBuilder);
                if (compiledData == null) {
                    throw new IllegalStateException("No compiled data for literal sources");
                }
                Consumer<RhsContext> compiledRhs = compiledData.rhs();
                if (compiledRhs == null) {
                    throw new IllegalStateException("No compiled RHS for literal actions");
                }
                ruleBuilder.setRhs(compiledRhs);
            }
            RuleDescriptor descriptor = RuleDescriptor.factory(this, ruleBuilder, handles, salience);
            descriptors.add(descriptor);
            ++currentRuleCount;
        }
        return descriptors;
    }

    Consumer<RhsContext> compileRHS(LiteralExpression rhs) {
        this._assertActive();
        try {
            JustRhsRuleData sources = new JustRhsRuleData(rhs);
            return this.compileRules(Collections.singletonList(sources)).iterator().next().rhs();
        }
        catch (CompilationException e) {
            e.log(LOGGER, Level.WARNING);
            throw new IllegalStateException(e);
        }
    }

    <S extends RuleLiteralData<R1>, R1 extends Rule> Collection<RuleCompiledSources<S, R1>> compileRules(Collection<S> sources) throws CompilationException {
        this._assertActive();
        return this.service.getLiteralSourceCompiler().compile(this, sources);
    }

    private FieldReference resolveFieldReference(String arg, NamedType.Resolver typeMapper) {
        this._assertActive();
        return this.getExpressionResolver().resolve(arg, typeMapper);
    }

    @Override
    public FieldReference[] resolveFieldReferences(String[] arg, NamedType.Resolver typeMapper) {
        this._assertActive();
        FieldReference[] refs = new FieldReference[arg.length];
        for (int i = 0; i < arg.length; ++i) {
            refs[i] = this.resolveFieldReference(arg[i], typeMapper);
        }
        return refs;
    }

    @Override
    public final synchronized ExpressionResolver getExpressionResolver() {
        this._assertActive();
        if (this.expressionResolver == null) {
            this.expressionResolver = this.service.getExpressionResolverProvider().instance(this);
        }
        return this.expressionResolver;
    }

    abstract void _assertActive();

    @Override
    public Collection<LiteralEvaluator> compile(Collection<LiteralExpression> expressions) throws CompilationException {
        IdentityHashMap mapping = new IdentityHashMap();
        expressions.forEach(expression -> {
            JustConditionsRuleData data = mapping.computeIfAbsent(expression, k -> new JustConditionsRuleData(expression.getContext()));
            data.conditions().add(expression.getSource());
        });
        return this.compileRules(mapping.values()).stream().flatMap(compiled -> compiled.conditions().stream()).collect(Collectors.toList());
    }
}

