/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.evrete.api.NamedType;

public class DefaultTypeResolver
implements NamedType.Resolver {
    private final Map<String, NamedType> map = new ConcurrentHashMap<String, NamedType>();

    @Override
    public NamedType resolve(String var) {
        NamedType t = this.map.get(var);
        if (t == null) {
            throw new NoSuchElementException("No type registered with variable '" + var + "'");
        }
        return t;
    }

    void copyFrom(DefaultTypeResolver other) {
        this.map.putAll(other.map);
    }

    public void save(NamedType value) {
        NamedType prev = this.map.put(value.getName(), value);
        if (prev != null) {
            throw new IllegalArgumentException("Duplicate type reference '" + value.getName() + "'");
        }
    }

    @Override
    public final Collection<NamedType> getDeclaredFactTypes() {
        return this.map.values();
    }
}

