/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import javax.tools.JavaFileObject;
import org.evrete.runtime.compiler.AbstractJavaObject;

public class DestinationClassObject
extends AbstractJavaObject {
    private final String binaryName;
    private final ByteArrayOutputStream outputStream;
    private final URI uri;

    public DestinationClassObject(String binaryName) {
        this.binaryName = binaryName;
        this.outputStream = new ByteArrayOutputStream();
        this.uri = URI.create("out:///" + binaryName.replaceAll("\\.", "/") + JavaFileObject.Kind.CLASS.extension);
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return kind.equals((Object)this.getKind());
    }

    @Override
    public OutputStream openOutputStream() {
        return this.outputStream;
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public InputStream openInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        throw new UnsupportedOperationException();
    }

    byte[] getBytes() {
        return this.outputStream.toByteArray();
    }

    @Override
    String getBinaryName() {
        return this.binaryName;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.CLASS;
    }
}

