/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.function.Predicate;
import org.evrete.AbstractRule;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FactBuilder;
import org.evrete.api.FieldReference;
import org.evrete.api.LiteralEvaluator;
import org.evrete.api.LiteralExpression;
import org.evrete.api.NamedType;
import org.evrete.api.RuntimeContext;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.builders.RuleBuilder;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultLhsBuilder;
import org.evrete.runtime.DefaultRuleSetBuilder;
import org.evrete.runtime.LhsBuilderImpl;
import org.evrete.runtime.LhsConditions;
import org.evrete.runtime.LhsConditionsHolder;
import org.evrete.runtime.RuleBuilderImpl;
import org.evrete.runtime.compiler.CompilationException;
import org.evrete.runtime.evaluation.EvaluatorOfArray;
import org.evrete.runtime.evaluation.EvaluatorOfPredicate;

class DefaultRuleBuilder<C extends RuntimeContext<C>>
extends AbstractRule
implements RuleBuilder<C>,
LhsConditionsHolder {
    private final DefaultLhsBuilder<C> lhsBuilder;
    private final DefaultRuleSetBuilder<C> ruleSetBuilder;

    DefaultRuleBuilder(DefaultRuleSetBuilder<C> ruleSetBuilder, String name) {
        super(name);
        this.ruleSetBuilder = ruleSetBuilder;
        this.lhsBuilder = new DefaultLhsBuilder(this);
    }

    DefaultRuleSetBuilder<C> getRuleSetBuilder() {
        return this.ruleSetBuilder;
    }

    String literalRhs() {
        return super.getLiteralRhs();
    }

    @Override
    public LhsConditions getConditions() {
        return this.lhsBuilder.getConditions();
    }

    @Override
    public Collection<NamedType> getDeclaredFactTypes() {
        return this.lhsBuilder.getDeclaredFactTypes();
    }

    @Override
    public DefaultRuleBuilder<C> set(String property, Object value) {
        super.set(property, value);
        return this;
    }

    @Override
    public DefaultRuleBuilder<C> salience(int salience) {
        this.setSalience(salience);
        return this;
    }

    @Override
    public NamedType resolve(String var) {
        return this.lhsBuilder.resolve(var);
    }

    @Override
    public <Z> RuleBuilder<C> property(String property, Z value) {
        this.set(property, value);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> getLhs() {
        return this.lhsBuilder;
    }

    @Override
    public C getRuntime() {
        return (C)this.runtime();
    }

    @Deprecated
    void copyFrom(RuleBuilderImpl<C> old) {
        this.salience(old.getSalience());
        this.setName(old.getName());
        this.lhsBuilder.copyFrom((LhsBuilderImpl<C>)old.getLhs());
        String literalRhs = old.getLiteralRhs();
        if (literalRhs != null) {
            this.setRhs(literalRhs);
        } else {
            this.setRhs(old.getRhs());
        }
    }

    @Override
    public DefaultLhsBuilder<C> forEach(Collection<FactBuilder> facts) {
        return this.lhsBuilder.buildLhs(facts);
    }

    AbstractRuntime<?, C> runtime() {
        return this.ruleSetBuilder.getRuntime();
    }

    @Override
    public EvaluatorHandle createCondition(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        return this.runtime().addEvaluator(new EvaluatorOfPredicate(predicate, references), complexity);
    }

    @Override
    public EvaluatorHandle createCondition(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        return this.runtime().addEvaluator(new EvaluatorOfArray(predicate, references), complexity);
    }

    @Override
    public EvaluatorHandle createCondition(String expression, double complexity) throws CompilationException {
        LiteralEvaluator evaluator = this.runtime().compile(LiteralExpression.of(expression, this));
        return this.runtime().addEvaluator(evaluator, complexity);
    }

    @Override
    public EvaluatorHandle createCondition(ValuesPredicate predicate, double complexity, String ... references) {
        return this.createCondition(predicate, complexity, this.resolveFieldReferences(references));
    }

    @Override
    public EvaluatorHandle createCondition(Predicate<Object[]> predicate, double complexity, String ... references) {
        return this.createCondition(predicate, complexity, this.resolveFieldReferences(references));
    }

    private FieldReference[] resolveFieldReferences(String[] references) {
        return this.runtime().resolveFieldReferences(references, this);
    }
}

