/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.evrete.api.FactHandleVersioned;
import org.evrete.api.KeyMode;
import org.evrete.api.KeyedFactStorage;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.api.ValueHandle;
import org.evrete.spi.minimal.LinkedFactHandles;
import org.evrete.spi.minimal.MemoryKeyMulti;

class SharedAlphaData
implements KeyedFactStorage {
    private final LinkedFactHandles[] dataWrappers = new LinkedFactHandles[KeyMode.values().length];

    SharedAlphaData() {
        for (KeyMode mode : KeyMode.values()) {
            int idx = mode.ordinal();
            this.dataWrappers[idx] = new LinkedFactHandles();
        }
    }

    @Override
    public void write(ValueHandle partialKey) {
    }

    @Override
    public void write(Collection<FactHandleVersioned> factHandles) {
        LinkedFactHandles data = this.get(KeyMode.OLD_NEW);
        for (FactHandleVersioned h : factHandles) {
            data.add(h);
        }
    }

    LinkedFactHandles get(KeyMode mode) {
        return this.dataWrappers[mode.ordinal()];
    }

    @Override
    public ReIterator<MemoryKey> keys(KeyMode mode) {
        return new KeyIterator();
    }

    @Override
    public ReIterator<FactHandleVersioned> values(KeyMode mode, MemoryKey key) {
        return this.get(mode).iterator();
    }

    @Override
    public void clear() {
        for (LinkedFactHandles wrapper : this.dataWrappers) {
            wrapper.clear();
        }
    }

    @Override
    public void commitChanges() {
        LinkedFactHandles delta = this.get(KeyMode.OLD_NEW);
        this.get(KeyMode.OLD_OLD).consume(delta);
    }

    private static class KeyIterator
    implements ReIterator<MemoryKey> {
        private final MemoryKeyMulti row = new MemoryKeyMulti();
        private boolean hasNext = true;

        KeyIterator() {
        }

        @Override
        public long reset() {
            this.hasNext = true;
            return 1L;
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public MemoryKey next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.row;
            }
            throw new NoSuchElementException();
        }
    }
}

