/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.HashMap;
import java.util.Map;

final class StringLiteralEncoder {
    private static final String PREFIX = "${const";
    private static final String SUFFIX = "}";
    private static final char[] QUOTES = new char[]{'\'', '\"', '`'};
    private final String original;
    private final Encoded encoded;
    private final Map<String, String> stringConstantMap;

    private StringLiteralEncoder(String original, Encoded encoded, Map<String, String> stringConstantMap) {
        this.original = original;
        this.encoded = encoded;
        this.stringConstantMap = stringConstantMap;
    }

    static StringLiteralEncoder of(String s, boolean stripWhiteSpaces) {
        int stringConstantId = 0;
        HashMap<String, String> stringConstantMap = new HashMap<String, String>();
        String current = s;
        for (char quote : QUOTES) {
            int start;
            while ((start = current.indexOf(quote)) >= 0) {
                String varName;
                int end = current.indexOf(quote, start + 1);
                if (end < 0) {
                    throw new IllegalArgumentException("Unbalanced quote at position " + start + " in " + current);
                }
                String stringConstant = current.substring(start, end + 1);
                while (current.contains(varName = PREFIX + stringConstantId++ + SUFFIX) || s.contains(varName)) {
                }
                stringConstantMap.put(varName, stringConstant.substring(1, stringConstant.length() - 1));
                current = current.replace(stringConstant, varName);
            }
        }
        current = stripWhiteSpaces ? current.replaceAll("\\s", "") : current.replaceAll("\\s{2,}", " ");
        return new StringLiteralEncoder(s, new Encoded(current), stringConstantMap);
    }

    public Map<String, String> getConstantMap() {
        return this.stringConstantMap;
    }

    public String unwrapLiterals(String arg) {
        String s = arg;
        for (Map.Entry<String, String> entry : this.stringConstantMap.entrySet()) {
            s = s.replace(entry.getKey(), "\"" + entry.getValue() + "\"");
        }
        return s;
    }

    public Encoded getEncoded() {
        return this.encoded;
    }

    public String toString() {
        return "StringLiteralRemover{original='" + this.original + '\'' + ", converted='" + this.encoded + '\'' + ", stringConstantMap=" + this.stringConstantMap + '}';
    }

    static final class Encoded {
        final String value;

        public Encoded(String value) {
            this.value = value;
        }
    }
}

