/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.evrete.api.EvaluatorHandle;
import org.evrete.api.FactBuilder;
import org.evrete.api.FieldReference;
import org.evrete.api.NamedType;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.ValuesPredicate;
import org.evrete.api.builders.LhsBuilder;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.DefaultRuleBuilder;
import org.evrete.runtime.DefaultRuleSetBuilder;
import org.evrete.runtime.DefaultTypeResolver;
import org.evrete.runtime.LhsBuilderImpl;
import org.evrete.runtime.LhsConditions;
import org.evrete.runtime.NamedTypeImpl;
import org.evrete.runtime.evaluation.EvaluatorOfArray;
import org.evrete.runtime.evaluation.EvaluatorOfPredicate;

class DefaultLhsBuilder<C extends RuntimeContext<C>>
extends DefaultTypeResolver
implements LhsBuilder<C> {
    private final DefaultRuleBuilder<C> ruleBuilder;
    private final AbstractRuntime<?, C> runtime;
    private final LhsConditions conditions = new LhsConditions();

    DefaultLhsBuilder(DefaultRuleBuilder<C> ruleBuilder) {
        this.ruleBuilder = ruleBuilder;
        this.runtime = ruleBuilder.runtime();
    }

    @Override
    public synchronized NamedTypeImpl addFactDeclaration(String name, Type<?> type) {
        NamedTypeImpl factType = new NamedTypeImpl(type, name);
        this.save(factType);
        return factType;
    }

    LhsConditions getConditions() {
        return this.conditions;
    }

    @Deprecated
    void copyFrom(LhsBuilderImpl<C> old) {
        super.copyFrom(old);
        this.conditions.copyFrom(old.getConditions());
    }

    @Override
    public DefaultRuleSetBuilder<C> execute(Consumer<RhsContext> consumer) {
        this.ruleBuilder.setRhs(consumer);
        return this.ruleBuilder.getRuleSetBuilder();
    }

    @Override
    public DefaultRuleSetBuilder<C> execute(String literalRhs) {
        this.ruleBuilder.setRhs(literalRhs);
        return this.ruleBuilder.getRuleSetBuilder();
    }

    @Override
    public NamedType addFactDeclaration(String name, Class<?> type) {
        Type<?> t = this.runtime.getTypeResolver().getOrDeclare(type);
        return this.addFactDeclaration(name, (Type)t);
    }

    @Override
    public NamedType addFactDeclaration(String name, String type) {
        return this.addFactDeclaration(name, this.runtime.getTypeResolver().getOrDeclare(type));
    }

    @Override
    public DefaultLhsBuilder<C> where(EvaluatorHandle ... expressions) {
        if (expressions == null) {
            return this;
        }
        for (EvaluatorHandle expression : expressions) {
            this.conditions.add(Objects.requireNonNull(expression));
        }
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(String expression, double complexity) {
        this.whereInner(expression, complexity);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(ValuesPredicate predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(Predicate<Object[]> predicate, double complexity, FieldReference ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(Predicate<Object[]> predicate, double complexity, String ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public DefaultLhsBuilder<C> where(ValuesPredicate predicate, double complexity, FieldReference ... references) {
        this.whereInner(predicate, complexity, references);
        return this;
    }

    @Override
    public DefaultRuleSetBuilder<C> execute() {
        return this.ruleBuilder.getRuleSetBuilder();
    }

    DefaultLhsBuilder<C> buildLhs(Collection<FactBuilder> facts) {
        if (facts == null || facts.isEmpty()) {
            return this;
        }
        for (FactBuilder f : facts) {
            Class<?> c = f.getResolvedType();
            if (c == null) {
                this.addFactDeclaration(f.getName(), f.getUnresolvedType());
                continue;
            }
            this.addFactDeclaration(f.getName(), c);
        }
        return this;
    }

    private void whereInner(String expression, double complexity) {
        this.conditions.add(expression, complexity);
    }

    private void whereInner(ValuesPredicate predicate, double complexity, FieldReference[] references) {
        this.conditions.add(new EvaluatorOfPredicate(Objects.requireNonNull(predicate), references), complexity);
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, FieldReference[] references) {
        this.conditions.add(new EvaluatorOfArray(Objects.requireNonNull(predicate), references), complexity);
    }

    private void whereInner(ValuesPredicate predicate, double complexity, String[] references) {
        FieldReference[] descriptor = this.resolveFieldReferences(references);
        EvaluatorOfPredicate evaluator = new EvaluatorOfPredicate(Objects.requireNonNull(predicate), descriptor);
        this.conditions.add(evaluator, complexity);
    }

    private void whereInner(Predicate<Object[]> predicate, double complexity, String[] references) {
        FieldReference[] descriptor = this.resolveFieldReferences(references);
        EvaluatorOfArray evaluator = new EvaluatorOfArray(Objects.requireNonNull(predicate), descriptor);
        this.conditions.add(evaluator, complexity);
    }

    private FieldReference[] resolveFieldReferences(String[] references) {
        return this.runtime.resolveFieldReferences(references, this);
    }
}

