/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.EnumMap;
import org.evrete.api.FieldValue;
import org.evrete.api.KeyMode;
import org.evrete.api.MemoryKey;
import org.evrete.api.ReIterator;
import org.evrete.collections.CollectionReIterator;
import org.evrete.runtime.Mask;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.RhsFactGroup;
import org.evrete.runtime.RhsFactGroupDescriptor;
import org.evrete.runtime.RuntimeFactType;
import org.evrete.runtime.RuntimeRuleImpl;
import org.evrete.util.CollectionUtils;

public class RhsFactGroupAlpha
implements RhsFactGroup {
    private static final MemoryKey KEY_MAIN = new VR(KeyMode.OLD_OLD.ordinal());
    private static final MemoryKey KEY_DELTA = new VR(KeyMode.OLD_NEW.ordinal());
    private final RuntimeFactType[] types;
    private final EnumMap<KeyMode, ReIterator<MemoryKey>> keyIterators = new EnumMap(KeyMode.class);
    private final Mask<MemoryAddress> memoryMask = Mask.addressMask();

    RhsFactGroupAlpha(RuntimeRuleImpl rule, RhsFactGroupDescriptor descriptor) {
        this.types = rule.asRuntimeTypes(descriptor.getTypes());
        assert (this.types.length > 0);
        if (this.types.length > 24) {
            throw new UnsupportedOperationException("Too many alpha nodes, another implementation required");
        }
        ArrayList<MemoryKey> mainCollection = new ArrayList<MemoryKey>();
        for (RuntimeFactType type : this.types) {
            mainCollection.add(KEY_MAIN);
            this.memoryMask.set(type.getMemoryAddress());
        }
        CollectionReIterator mainKeyIterator = new CollectionReIterator(mainCollection);
        ArrayList<MemoryKey> deltaCollection = new ArrayList<MemoryKey>();
        for (int i = 1; i < 1 << this.types.length; ++i) {
            for (int bit = 0; bit < this.types.length; ++bit) {
                if ((i & 1 << bit) == 0) {
                    deltaCollection.add(KEY_MAIN);
                    continue;
                }
                deltaCollection.add(KEY_DELTA);
            }
        }
        CollectionReIterator deltaKeyIterator = new CollectionReIterator(deltaCollection);
        this.keyIterators.put(KeyMode.OLD_OLD, mainKeyIterator);
        this.keyIterators.put(KeyMode.OLD_NEW, deltaKeyIterator);
        this.keyIterators.put(KeyMode.NEW_NEW, CollectionUtils.emptyReIterator());
    }

    @Override
    public RuntimeFactType[] types() {
        return this.types;
    }

    @Override
    public ReIterator<MemoryKey> keyIterator(KeyMode mode) {
        return this.keyIterators.get((Object)mode);
    }

    @Override
    public Mask<MemoryAddress> getMemoryMask() {
        return this.memoryMask;
    }

    private static class VR
    implements MemoryKey {
        private final int transientValue;

        VR(int transientValue) {
            this.transientValue = transientValue;
        }

        @Override
        public FieldValue get(int fieldIndex) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMetaValue() {
            return this.transientValue;
        }

        @Override
        public void setMetaValue(int i) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.transientValue == 0 ? "MAIN" : "DELTA";
        }
    }
}

