/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.async;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.evrete.api.FactHandle;
import org.evrete.api.FactStorage;
import org.evrete.api.ReIterator;
import org.evrete.collections.LinkedDataRWD;
import org.evrete.runtime.AtomicMemoryAction;
import org.evrete.runtime.FactActionBuffer;
import org.evrete.runtime.FactRecord;
import org.evrete.runtime.FactRecordDelta;
import org.evrete.runtime.KeyMemoryBucket;
import org.evrete.runtime.Mask;
import org.evrete.runtime.MemoryAddress;
import org.evrete.runtime.RuntimeFact;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.async.Completer;

public class ComputeDeltaMemoryTask
extends Completer {
    private static final long serialVersionUID = 7921593735990639599L;
    private final Collection<TypeMemoryDeltaTask> subtasks = new LinkedList<TypeMemoryDeltaTask>();
    private final transient Mask<MemoryAddress> deleteMask = Mask.addressMask();
    private final Collection<KeyMemoryBucket> bucketsToCommit = new LinkedList<KeyMemoryBucket>();

    public ComputeDeltaMemoryTask(FactActionBuffer buffer, SessionMemory memory) {
        memory.forEach(tm -> this.subtasks.add(new TypeMemoryDeltaTask(this, (TypeMemory)tm, buffer)));
    }

    @Override
    protected void execute() {
        this.tailCall(this.subtasks, o -> o);
    }

    public Mask<MemoryAddress> getDeleteMask() {
        return this.deleteMask;
    }

    public Collection<KeyMemoryBucket> getBucketsToCommit() {
        return this.bucketsToCommit;
    }

    @Override
    protected void onCompletion() {
        Iterator<TypeMemoryDeltaTask> it = this.subtasks.iterator();
        while (it.hasNext()) {
            TypeMemoryDeltaTask sub = it.next();
            this.deleteMask.or(sub.deleteMask);
            this.bucketsToCommit.addAll(sub.bucketsToCommit);
            it.remove();
        }
    }

    private static class TypeMemoryDeltaTask
    extends Completer {
        private static final long serialVersionUID = 7844452448442224060L;
        private final transient TypeMemory tm;
        private final transient FactActionBuffer buffer;
        private final transient FactStorage<FactRecord> factStorage;
        private final transient Mask<MemoryAddress> deleteMask = Mask.addressMask();
        private final transient LinkedDataRWD<RuntimeFact> inserts = new LinkedDataRWD();
        private final Collection<BucketInsertTask> bucketInsertTasks = new LinkedList<BucketInsertTask>();
        private final Collection<KeyMemoryBucket> bucketsToCommit = new LinkedList<KeyMemoryBucket>();

        TypeMemoryDeltaTask(Completer completer, TypeMemory tm, FactActionBuffer buffer) {
            super(completer);
            this.tm = tm;
            this.buffer = buffer;
            this.factStorage = tm.getFactStorage();
        }

        @Override
        protected void onCompletion() {
            Iterator<BucketInsertTask> bi = this.bucketInsertTasks.iterator();
            while (bi.hasNext()) {
                BucketInsertTask task = bi.next();
                if (task.atLeastOneInserted) {
                    KeyMemoryBucket bucket = task.bucket;
                    this.bucketsToCommit.add(bucket);
                }
                bi.remove();
            }
            this.inserts.clear();
        }

        @Override
        protected void execute() {
            ReIterator<AtomicMemoryAction> it = this.buffer.actions(this.tm.getType());
            block5: while (it.hasNext()) {
                AtomicMemoryAction a = (AtomicMemoryAction)it.next();
                FactHandle handle = a.handle;
                switch (a.action) {
                    case RETRACT: {
                        FactRecord record = this.factStorage.getFact(handle);
                        if (record != null) {
                            this.deleteMask.or(record.getBucketsMask());
                        }
                        this.factStorage.delete(handle);
                        continue block5;
                    }
                    case INSERT: {
                        this.inserts.add(this.tm.createFactRuntime(handle, a.getDelta().getLatest()));
                        continue block5;
                    }
                    case UPDATE: {
                        FactRecordDelta delta = a.getDelta();
                        FactRecord previous = delta.getPrevious();
                        this.deleteMask.or(previous.getBucketsMask());
                        FactRecord latest = a.getDelta().getLatest();
                        this.factStorage.update(handle, latest);
                        this.inserts.add(this.tm.createFactRuntime(handle, latest));
                        continue block5;
                    }
                }
                throw new IllegalStateException();
            }
            if (this.inserts.size() > 0L) {
                this.tm.forEach(bucket -> {
                    this.addToPendingCount(1);
                    BucketInsertTask task = new BucketInsertTask(this, (KeyMemoryBucket)bucket, (Iterable<RuntimeFact>)this.inserts);
                    this.bucketInsertTasks.add(task);
                    task.fork();
                });
                this.postInsert();
            }
        }

        private void postInsert() {
            for (RuntimeFact fact : this.inserts) {
                FactHandle handle;
                FactRecord record;
                Mask<MemoryAddress> mask = fact.factRecord.getBucketsMask();
                if (mask.cardinality() <= 0 || (record = this.factStorage.getFact(handle = fact.factHandle.getHandle())) == null) continue;
                if (record.getBucketsMask().equals(mask)) {
                    return;
                }
                this.factStorage.update(handle, fact.factRecord);
            }
        }
    }

    static class BucketInsertTask
    extends Completer {
        private static final long serialVersionUID = -1537128295059722535L;
        private final transient KeyMemoryBucket bucket;
        private final transient Iterable<RuntimeFact> inserts;
        private boolean atLeastOneInserted;

        BucketInsertTask(TypeMemoryDeltaTask completer, KeyMemoryBucket bucket, Iterable<RuntimeFact> inserts) {
            super(completer);
            this.bucket = bucket;
            this.inserts = inserts;
        }

        @Override
        protected void execute() {
            this.atLeastOneInserted = this.bucket.insert(this.inserts);
        }
    }
}

