/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evrete.api.FieldReference;
import org.evrete.spi.minimal.FieldReferenceImpl;
import org.evrete.spi.minimal.StringLiteralEncoder;
import org.evrete.util.NextIntSupplier;

class ConditionStringTerm
extends FieldReferenceImpl {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$[a-zA-Z0-9]+(\\.[_a-zA-Z][_a-zA-Z0-9]*)*");
    final int start;
    final int end;
    final String varName;

    ConditionStringTerm(int start, int end, FieldReference delegate, NextIntSupplier fieldCounter) {
        super(delegate);
        this.start = start;
        this.end = end;
        this.varName = "var" + fieldCounter.next();
    }

    ConditionStringTerm(int start, int end, ConditionStringTerm existing) {
        super(existing);
        this.start = start;
        this.end = end;
        this.varName = existing.varName;
    }

    private static ConditionStringTerm resolveTerm(int start, int actualEnd, FieldReference ref, NextIntSupplier fieldCounter, List<ConditionStringTerm> terms) {
        for (ConditionStringTerm t : terms) {
            if (!t.type().equals(ref.type()) || !t.field().equals(ref.field())) continue;
            return new ConditionStringTerm(start, actualEnd, t);
        }
        return new ConditionStringTerm(start, actualEnd, ref, fieldCounter);
    }

    static List<ConditionStringTerm> resolveTerms(StringLiteralEncoder.Encoded encoded, Function<String, FieldReference> resolver) {
        String expression = encoded.value;
        Matcher m = REFERENCE_PATTERN.matcher(expression);
        ArrayList<ConditionStringTerm> terms = new ArrayList<ConditionStringTerm>();
        NextIntSupplier fieldCounter = new NextIntSupplier();
        while (m.find()) {
            int end;
            int start = m.start();
            int actualEnd = end = m.end();
            if (end < expression.length() && expression.charAt(end) == '(') {
                actualEnd = expression.substring(start, end).lastIndexOf(46) + start;
            }
            String s = expression.substring(start, actualEnd);
            FieldReference fieldReference = resolver.apply(s);
            ConditionStringTerm t = ConditionStringTerm.resolveTerm(start, actualEnd, fieldReference, fieldCounter, terms);
            terms.add(t);
        }
        return terms;
    }
}

