/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.StringJoiner;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.evrete.api.FactHandle;
import org.evrete.api.FactStorage;
import org.evrete.api.ReIterator;
import org.evrete.api.Type;
import org.evrete.collections.AbstractLinearHash;
import org.evrete.spi.minimal.FactHandleImpl;

class DefaultFactStorage<T>
implements FactStorage<T> {
    private final TupleCollection<T> collection;
    private final Function<FactTuple<T>, FactStorage.Entry<T>> ITERATOR_MAPPER = t -> t;

    DefaultFactStorage(Type<?> type, BiPredicate<T, T> identityFunction) {
        this.collection = new TupleCollection<T>(type, identityFunction);
    }

    @Override
    public FactHandle insert(T fact) {
        return this.collection.insert(fact);
    }

    @Override
    public void delete(FactHandle handle) {
        this.collection.delete(handle);
    }

    @Override
    public void update(FactHandle handle, T newInstance) {
        this.collection.add(new FactTuple<T>((FactHandleImpl)handle, newInstance));
    }

    @Override
    public T getFact(FactHandle handle) {
        return this.collection.getFact((FactHandleImpl)handle);
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("\n");
        this.collection.forEachDataEntry(t -> sj.add(t.toString()));
        return sj.toString();
    }

    @Override
    public ReIterator<FactStorage.Entry<T>> iterator() {
        return this.collection.iterator(this.ITERATOR_MAPPER);
    }

    static class TupleCollection<T>
    extends AbstractLinearHash<FactTuple<T>> {
        private final BiPredicate<T, T> identityFunction;
        private final BiPredicate<FactTuple<T>, FactTuple<T>> equalsPredicate;
        private final BiPredicate<FactTuple<T>, FactHandleImpl> searchByHandle = (factTuple, o) -> factTuple.handle.id == o.id;
        private final BiPredicate<FactTuple<T>, T> searchByFact = new BiPredicate<FactTuple<T>, T>(){

            @Override
            public boolean test(FactTuple<T> factTuple, T o) {
                return identityFunction.test(factTuple.object, o);
            }
        };
        private final Type<?> type;
        private long handleId = 0L;

        TupleCollection(Type<?> type, BiPredicate<T, T> identityFunction) {
            this.identityFunction = identityFunction;
            this.equalsPredicate = (t1, t2) -> identityFunction.test(t1.object, t2.object);
            this.type = type;
        }

        void add(FactTuple<T> factTuple) {
            this.add(factTuple, this.equalsPredicate, factTuple);
        }

        FactHandleImpl insert(T fact) {
            FactTuple factTuple = this.insertIfAbsent(fact, this.searchByFact, (hash, t) -> {
                FactHandleImpl handle = new FactHandleImpl(this.handleId++, hash, this.type.getId());
                return new FactTuple<Object>(handle, fact);
            });
            return factTuple == null ? null : factTuple.handle;
        }

        void delete(FactHandle handle) {
            FactHandleImpl impl = (FactHandleImpl)handle;
            this.remove(impl, this.searchByHandle);
        }

        T getFact(FactHandleImpl impl) {
            FactTuple<T> t = this.get(impl, this.searchByHandle);
            return t == null ? null : (T)t.object;
        }
    }

    static class FactTuple<Z>
    implements FactStorage.Entry<Z> {
        private final FactHandleImpl handle;
        private final Z object;

        FactTuple(FactHandleImpl handle, Z object) {
            this.handle = handle;
            this.object = object;
        }

        @Override
        public FactHandle getHandle() {
            return this.handle;
        }

        @Override
        public Z getInstance() {
            return this.object;
        }

        public int hashCode() {
            return this.handle.hash;
        }

        public String toString() {
            return String.valueOf(this.handle) + " -> " + String.valueOf(this.object);
        }
    }
}

