/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Arrays;
import org.evrete.api.FieldValue;
import org.evrete.api.MemoryKey;
import org.evrete.spi.minimal.MemoryKeyHashed;

class MemoryKeyMulti
implements MemoryKey {
    private static final FieldValue[] EMPTY = new FieldValue[0];
    private final FieldValue[] data;
    private final int hash;
    private transient int transientValue;

    MemoryKeyMulti() {
        this.data = EMPTY;
        this.hash = 0;
    }

    MemoryKeyMulti(int fieldCount, MemoryKeyHashed key) {
        this.data = new FieldValue[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            this.data[i] = (FieldValue)key.values.apply(i);
        }
        this.hash = key.hash;
    }

    @Override
    public int getMetaValue() {
        return this.transientValue;
    }

    @Override
    public void setMetaValue(int i) {
        this.transientValue = i;
    }

    public String toString() {
        return Arrays.toString(this.data) + "/" + this.transientValue;
    }

    @Override
    public FieldValue get(int i) {
        return this.data[i];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryKeyMulti other = (MemoryKeyMulti)o;
        return Arrays.equals(other.data, this.data);
    }

    public final int hashCode() {
        return this.hash;
    }
}

