/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.function.Function;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.spi.minimal.TypeImpl;

class TypeFieldImpl
implements TypeField {
    private final String name;
    private final Class<?> valueType;
    private final TypeImpl<?> declaringType;
    private Function<Object, ?> function;

    TypeFieldImpl(TypeImpl<?> declaringType, String name, Class<?> valueType, Function<Object, ?> function) {
        this.name = name;
        this.valueType = valueType;
        this.function = function;
        this.declaringType = declaringType;
    }

    TypeFieldImpl(TypeFieldImpl other, TypeImpl<?> newType) {
        this(newType, other.name, other.valueType, other.function);
    }

    public void setFunction(Function<Object, ?> function) {
        this.function = function;
    }

    TypeFieldImpl copy(TypeImpl<?> newType) {
        return new TypeFieldImpl(this, newType);
    }

    @Override
    public Type<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public Class<?> getValueType() {
        return this.valueType;
    }

    @Override
    public <T> T readValue(Object subject) {
        return (T)this.function.apply(subject);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{name='" + this.name + "', valueType='" + String.valueOf(this.valueType) + "', function='" + String.valueOf(this.function) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeFieldImpl typeField = (TypeFieldImpl)o;
        return this.name.equals(typeField.name) && this.declaringType.equals(typeField.declaringType);
    }

    public int hashCode() {
        return this.name.hashCode() * 31 + this.declaringType.hashCode();
    }
}

