/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.evrete.api.ReIterator;

public final class CollectionUtils {
    private static final EmptyReIterator EMPTY_RE_ITERATOR = new EmptyReIterator();

    public static <T> T[] array(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <T> T[] copyOf(T[] arr) {
        return Arrays.copyOf(arr, arr.length);
    }

    public static <T> ReIterator<T> emptyReIterator() {
        return EMPTY_RE_ITERATOR;
    }

    public static <E> List<List<E>> permutation(List<E> l) {
        ArrayList<E> original = new ArrayList<E>(l);
        if (original.isEmpty()) {
            ArrayList result = new ArrayList();
            result.add(new ArrayList());
            return result;
        }
        E first = original.remove(0);
        ArrayList<List<ArrayList<E>>> result = new ArrayList<List<ArrayList<E>>>();
        List<List<E>> permutations = CollectionUtils.permutation(original);
        for (List<E> list : permutations) {
            for (int i = 0; i <= list.size(); ++i) {
                ArrayList<E> temp = new ArrayList<E>(list);
                temp.add(i, first);
                result.add(temp);
            }
        }
        return result;
    }

    public static <E, T extends Collection<E>> Collection<List<E>> combinations(Collection<T> sources) {
        LinkedHashMap<Integer, Collection> mapper = new LinkedHashMap<Integer, Collection>();
        int counter = 0;
        for (Collection collection : sources) {
            mapper.put(counter++, collection);
        }
        List combinations = CollectionUtils.combinations(mapper, LinkedHashMap::new);
        LinkedList result = new LinkedList();
        for (Map m : combinations) {
            LinkedList l = new LinkedList(m.values());
            result.add(l);
        }
        return result;
    }

    private static <K, V, C extends Collection<V>> List<Map<K, V>> combinations(Map<K, C> sources, Supplier<Map<K, V>> emptyMapSupplier) {
        Iterator<Map.Entry<K, C>> it = sources.entrySet().iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        Map.Entry<K, C> rootCollection = it.next();
        Collection c = (Collection)rootCollection.getValue();
        K k = rootCollection.getKey();
        ArrayList<Map<K, V>> response = new ArrayList<Map<K, V>>(c.size());
        for (Object o : c) {
            Map m = emptyMapSupplier.get();
            m.put(k, o);
            response.add(m);
        }
        while (it.hasNext()) {
            rootCollection = it.next();
            c = (Collection)rootCollection.getValue();
            k = rootCollection.getKey();
            if (c.isEmpty()) continue;
            ArrayList newResponse = new ArrayList(c.size() * response.size());
            for (Object e : c) {
                for (Map map : response) {
                    Map newResponseEntry = emptyMapSupplier.get();
                    newResponseEntry.putAll(map);
                    newResponseEntry.put(k, e);
                    newResponse.add(newResponseEntry);
                }
            }
            response = newResponse;
        }
        return response;
    }

    public static void systemFill(int[] array, int value) {
        CollectionUtils.systemFill(array, array.length, value);
    }

    public static void systemFill(boolean[] array, boolean value) {
        CollectionUtils.systemFill(array, array.length, value);
    }

    public static <T> void systemFill(T[] array, T value) {
        CollectionUtils.systemFill(array, array.length, value);
    }

    private static <T> void systemFill(T[] array, int toIndex, T value) {
        int len = toIndex;
        if (len < 64) {
            CollectionUtils.fillObjects(array, toIndex, value);
        } else {
            array[0] = value;
            for (int i = 1; i < len; i += i) {
                System.arraycopy(array, 0, array, i, Math.min(len - i, i));
            }
        }
    }

    private static void systemFill(int[] array, int toIndex, int value) {
        int len = toIndex;
        if (len < 64) {
            CollectionUtils.fillIntegers(array, toIndex, value);
        } else {
            array[0] = value;
            for (int i = 1; i < len; i += i) {
                System.arraycopy(array, 0, array, i, Math.min(len - i, i));
            }
        }
    }

    private static void systemFill(boolean[] array, int toIndex, boolean value) {
        int len = toIndex;
        if (len < 64) {
            CollectionUtils.fillBooleans(array, toIndex, value);
        } else {
            array[0] = value;
            for (int i = 1; i < len; i += i) {
                System.arraycopy(array, 0, array, i, Math.min(len - i, i));
            }
        }
    }

    private static void fillBooleans(boolean[] a, int toIndex, boolean val) {
        for (int i = 0; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    private static void fillIntegers(int[] a, int toIndex, int val) {
        for (int i = 0; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    private static <T> void fillObjects(T[] a, int toIndex, T val) {
        for (int i = 0; i < toIndex; ++i) {
            a[i] = val;
        }
    }

    private static class EmptyReIterator
    implements ReIterator<Object> {
        private EmptyReIterator() {
        }

        @Override
        public long reset() {
            return 0L;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    }
}

