/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api;

import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.evrete.api.FactHandle;
import org.evrete.api.RuleSession;

public interface StatefulSession
extends RuleSession<StatefulSession>,
AutoCloseable {
    @Override
    public StatefulSession fire();

    @Deprecated
    default public <T> Future<T> fireAsync(T result) {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Deprecated
    default public Future<StatefulSession> fireAsync() {
        throw new UnsupportedOperationException("Deprecated");
    }

    @Override
    public void close();

    public void clear();

    default public StatefulSession forEachFact(BiConsumer<FactHandle, Object> consumer) {
        this.streamFactEntries().forEach(entry -> consumer.accept((FactHandle)entry.getKey(), entry.getValue()));
        return this;
    }

    default public StatefulSession forEachFact(BiPredicate<FactHandle, Object> filter, BiConsumer<FactHandle, Object> consumer) {
        return this.forEachFact((FactHandle factHandle, Object o) -> {
            if (filter.test((FactHandle)factHandle, o)) {
                consumer.accept((FactHandle)factHandle, o);
            }
        });
    }

    default public StatefulSession forEachFact(Consumer<Object> consumer) {
        return this.forEachFact((FactHandle factHandle, Object o) -> consumer.accept(o));
    }

    default public <T> StatefulSession forEachFact(Class<T> type, Consumer<T> consumer) {
        this.streamFacts(type).forEach(consumer);
        return this;
    }

    default public <T> StatefulSession forEachFact(String type, Consumer<T> consumer) {
        this.streamFacts(type).forEach(consumer);
        return this;
    }

    default public <T> StatefulSession forEachFact(Class<T> type, Predicate<T> filter, Consumer<T> consumer) {
        return this.forEachFact(type, (T t) -> {
            if (filter.test(t)) {
                consumer.accept(t);
            }
        });
    }

    default public <T> StatefulSession forEachFact(String type, Predicate<T> filter, Consumer<T> consumer) {
        return this.forEachFact(type, (T o) -> {
            Object t = o;
            if (filter.test(t)) {
                consumer.accept(t);
            }
        });
    }

    default public StatefulSession insertAndFire(Iterable<?> objects) {
        this.insert0(objects, true);
        return this.fire();
    }

    default public StatefulSession insertAndFire(Object ... objects) {
        this.insert0(objects, true);
        return this.fire();
    }
}

