/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.api.events;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;

public final class Events {
    private Events() {
    }

    public static class Subscriptions {
        private final Set<Subscription> subscriptions = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

        public Subscriptions add(Subscription subscription) {
            this.subscriptions.add(subscription);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Set<Subscription> set = this.subscriptions;
            synchronized (set) {
                Iterator<Subscription> iterator = this.subscriptions.iterator();
                while (iterator.hasNext()) {
                    iterator.next().cancel();
                    iterator.remove();
                }
            }
        }
    }

    public static interface Event {
    }

    public static interface Subscription {
        public void cancel();
    }

    public static interface Publisher<E extends Event> {
        public Subscription subscribe(boolean var1, Consumer<E> var2);

        default public void subscribe(Subscriptions sink, boolean async, Consumer<E> listener) {
            sink.add(this.subscribe(async, listener));
        }

        default public Subscription subscribe(Consumer<E> listener) {
            return this.subscribe(false, listener);
        }

        default public void subscribe(Subscriptions sink, Consumer<E> listener) {
            sink.add(this.subscribe(listener));
        }

        default public Subscription subscribeAsync(Consumer<E> listener) {
            return this.subscribe(true, listener);
        }

        default public void subscribeAsync(Subscriptions sink, Consumer<E> listener) {
            sink.add(this.subscribeAsync(listener));
        }
    }
}

