/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.RhsContext;
import org.evrete.api.Rule;
import org.evrete.util.AbstractEnvironment;

public abstract class AbstractRule
extends AbstractEnvironment
implements Rule {
    public static final int NULL_SALIENCE = Integer.MIN_VALUE;
    private static final Logger LOGGER = Logger.getLogger(AbstractRule.class.getName());
    private final Consumer<RhsContext> nullRhs;
    protected Consumer<RhsContext> rhs;
    private String name;
    private int salience;
    private String literalRhs;

    protected AbstractRule(AbstractEnvironment environment, String name) {
        super(environment);
        this.name = Objects.requireNonNull(name);
        this.salience = Integer.MIN_VALUE;
        this.nullRhs = arg -> LOGGER.warning(() -> "No RHS is set for rule '" + this.name + "'");
        this.rhs = this.nullRhs;
    }

    protected AbstractRule(AbstractRule other, String ruleName, int salience) {
        super(other);
        this.name = ruleName;
        this.salience = salience;
        this.nullRhs = other.nullRhs;
        this.rhs = other.rhs;
        this.literalRhs = other.literalRhs;
    }

    @Override
    public Consumer<RhsContext> getRhs() {
        return this.rhs;
    }

    @Override
    public void setRhs(Consumer<RhsContext> rhs) {
        this.rhs = rhs == null ? this.nullRhs : rhs;
        this.literalRhs = null;
    }

    @Override
    public void setRhs(String literalRhs) {
        this.literalRhs = literalRhs;
    }

    public String getLiteralRhs() {
        return this.literalRhs;
    }

    @Override
    public final int getSalience() {
        return this.salience;
    }

    @Override
    public void setSalience(int salience) {
        this.salience = salience;
    }

    @Override
    public Rule set(String property, Object value) {
        super.set(property, value);
        return this;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void chainRhs(Consumer<RhsContext> consumer) {
        if (this.rhs == this.nullRhs || this.rhs == null) {
            this.setRhs(consumer);
        } else {
            this.setRhs(this.rhs.andThen(consumer));
        }
    }
}

