/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.evrete.api.ActivationMode;
import org.evrete.api.RuleSession;
import org.evrete.api.events.SessionCreatedEvent;
import org.evrete.api.events.SessionFireEvent;
import org.evrete.runtime.AbstractRuleSessionDeployment;
import org.evrete.runtime.ActivationContext;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.SessionRule;
import org.evrete.runtime.WorkMemoryActionBuffer;
import org.evrete.runtime.events.SessionCreatedEventImpl;

public abstract class AbstractRuleSession<S extends RuleSession<S>>
extends AbstractRuleSessionDeployment<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuleSession.class.getName());
    private final SessionMemory memory = new SessionMemory(this);

    AbstractRuleSession(KnowledgeRuntime knowledge) {
        super(knowledge);
        this.deployRules(knowledge.getRuleDescriptors(), false);
        this.broadcast(SessionCreatedEvent.class, new SessionCreatedEventImpl(this.getContextCreateStartTime(), this));
    }

    @Override
    public final SessionMemory getMemory() {
        return this.memory;
    }

    void clearInner() {
        for (SessionRule rule : this.ruleStorage) {
            rule.clear();
        }
        this.memory.clear();
        this.getActionBuffer().clear();
    }

    final void fireInner() {
        this._assertActive();
        this.fireInnerAsync().join();
    }

    private CompletableFuture<Void> fireInnerAsync() {
        this.broadcast(SessionFireEvent.class, () -> this);
        ActivationMode mode = this.getAgendaMode();
        ActivationContext context = new ActivationContext(this, this.ruleStorage.getList());
        WorkMemoryActionBuffer buffer = this.getActionBuffer();
        LOGGER.fine(() -> "Session mode: " + String.valueOf((Object)mode) + ", buffered facts: [" + buffer.bufferedActionCount() + "]");
        return this.fireCycle(context, mode, buffer);
    }

    private CompletableFuture<Void> fireCycle(ActivationContext ctx, ActivationMode mode, WorkMemoryActionBuffer actions) {
        if (actions.hasData()) {
            CompletableFuture<ActivationContext.Status> memoryDeltaStatus = ctx.computeDelta(actions);
            return memoryDeltaStatus.thenCompose(deltaStatus -> {
                WorkMemoryActionBuffer newActions = this.doAgenda(ctx, deltaStatus.getAgenda(), mode);
                return ctx.commitMemories((ActivationContext.Status)deltaStatus).thenCompose(unused -> this.fireCycle(ctx, mode, newActions));
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private WorkMemoryActionBuffer doAgenda(ActivationContext context, List<SessionRule> agenda, ActivationMode mode) {
        if (agenda.isEmpty()) {
            return WorkMemoryActionBuffer.EMPTY;
        }
        this.activationManager.onAgenda(context.incrementFireCount(), Collections.unmodifiableList(agenda));
        WorkMemoryActionBuffer destinationForRuleActions = new WorkMemoryActionBuffer();
        switch (mode) {
            case DEFAULT: {
                this.doAgendaDefault(agenda, destinationForRuleActions);
                break;
            }
            case CONTINUOUS: {
                this.doAgendaContinuous(agenda, destinationForRuleActions);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported activation mode: " + String.valueOf((Object)mode));
            }
        }
        return destinationForRuleActions;
    }

    private void doAgendaDefault(List<SessionRule> agenda, WorkMemoryActionBuffer destinationForRuleActions) {
        for (SessionRule rule : agenda) {
            if (!this.activationManager.test(rule)) continue;
            long activationCount = rule.callRhs(destinationForRuleActions);
            this.activationManager.onActivation(rule, activationCount);
            if (!destinationForRuleActions.hasData()) continue;
            return;
        }
    }

    private void doAgendaContinuous(List<SessionRule> agenda, WorkMemoryActionBuffer destinationForRuleActions) {
        for (SessionRule rule : agenda) {
            if (!this.activationManager.test(rule)) continue;
            long activationCount = rule.callRhs(destinationForRuleActions);
            this.activationManager.onActivation(rule, activationCount);
        }
    }
}

