/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.logging.Logger;
import org.evrete.api.FactHandle;
import org.evrete.api.IntToValue;
import org.evrete.api.RuleSession;
import org.evrete.api.Type;
import org.evrete.api.TypeResolver;
import org.evrete.api.spi.ValueIndexer;
import org.evrete.runtime.AbstractRuleSessionBase;
import org.evrete.runtime.ActiveEvaluatorGenerator;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.DeltaMemoryAction;
import org.evrete.runtime.FactFieldValues;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.Mask;
import org.evrete.runtime.StoredCondition;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.WorkMemoryActionBuffer;
import org.evrete.runtime.evaluation.AlphaConditionHandle;
import org.evrete.util.CommonUtils;

public abstract class AbstractRuleSessionOps<S extends RuleSession<S>>
extends AbstractRuleSessionBase<S> {
    private static final Logger LOGGER = Logger.getLogger(AbstractRuleSessionOps.class.getName());
    private final WorkMemoryActionBuffer actionBuffer = new WorkMemoryActionBuffer();

    AbstractRuleSessionOps(KnowledgeRuntime knowledge) {
        super(knowledge);
    }

    @Override
    public final <T> T getFact(FactHandle handle) {
        this._assertActive();
        DefaultFactHandle h = this.unwrapFactHandle(handle);
        FactHolder factHolder = this.getFactWrapper(h);
        return (T)(factHolder == null ? null : factHolder.getFact());
    }

    @Override
    public FactHandle insert0(Object fact, boolean resolveCollections) {
        return this.bufferInsertMultiple(fact, true, resolveCollections, this.actionBuffer);
    }

    @Override
    public FactHandle insert0(String type, Object fact, boolean resolveCollections) {
        return this.bufferInsertMultiple(type, fact, true, resolveCollections, this.actionBuffer);
    }

    @Override
    public final void update(FactHandle handle, Object newValue) {
        this._assertActive();
        DefaultFactHandle h = this.unwrapFactHandle(handle);
        this.bufferUpdate(true, h, newValue, this.actionBuffer);
    }

    DefaultFactHandle unwrapFactHandle(FactHandle handle) {
        if (handle instanceof DefaultFactHandle) {
            return (DefaultFactHandle)handle;
        }
        throw new IllegalArgumentException("Unknown type of fact handle: ");
    }

    @Override
    public final void delete(FactHandle handle) {
        this._assertActive();
        this.bufferDelete(handle, true, this.actionBuffer);
    }

    WorkMemoryActionBuffer getActionBuffer() {
        return this.actionBuffer;
    }

    FactHolder getFactWrapper(DefaultFactHandle handle) {
        return (FactHolder)this.getMemory().getTypeMemory(handle).get(handle);
    }

    void bufferDelete(DefaultFactHandle handle, boolean applyToStorage, FactHolder existing, WorkMemoryActionBuffer destination) {
        FactHolder deleteSubject;
        ActiveType type = this.getActiveType(handle);
        if (applyToStorage) {
            deleteSubject = (FactHolder)this.getMemory().getTypeMemory(handle).remove(handle);
            if (deleteSubject == null) {
                throw new IllegalArgumentException("Unknown fact handle: " + String.valueOf(handle));
            }
        } else {
            deleteSubject = existing;
        }
        destination.addDelete(new DeltaMemoryAction.Delete(type, deleteSubject, !applyToStorage));
        LOGGER.finer(() -> "New memory delete action buffered for handle " + String.valueOf(handle));
    }

    void bufferDelete(FactHandle handle, boolean applyToStorage, WorkMemoryActionBuffer destination) {
        DefaultFactHandle h = this.unwrapFactHandle(handle);
        ActiveType type = this.getActiveType(h);
        FactHolder existing = (FactHolder)this.getMemory().getTypeMemory(type.getId()).get(h);
        if (existing != null) {
            this.bufferDelete(h, applyToStorage, existing, destination);
        }
    }

    void bufferUpdate(boolean applyToStorage, DefaultFactHandle handle, Object newValue, WorkMemoryActionBuffer destination) {
        Objects.requireNonNull(newValue, "Null facts aren't supported");
        Type factType = this.getTypeResolver().resolve(newValue);
        if (factType == null) {
            LOGGER.warning(() -> "Unknown fact type, UPDATE operation skipped for: " + String.valueOf(newValue));
            return;
        }
        ActiveType activeType = this.getCreateIndexedType(factType);
        TypeMemory typeMemory = this.getMemory().getTypeMemory(activeType.getId());
        FactHolder existing = (FactHolder)typeMemory.get(handle);
        if (existing == null) {
            LOGGER.warning(() -> "Fact not found, UPDATE operation skipped for: " + String.valueOf(newValue));
        } else {
            Class<?> argClass;
            Class<?> expectedFactClass = activeType.getValue().getJavaClass();
            if (expectedFactClass.isAssignableFrom(argClass = newValue.getClass())) {
                this.bufferDelete(handle, applyToStorage, existing, destination);
                this.bufferInsertSingle(handle, factType, activeType, applyToStorage, newValue, destination);
            } else {
                throw new IllegalArgumentException("Argument type mismatch. Actual '" + String.valueOf(argClass) + "' vs expected '" + String.valueOf(expectedFactClass) + "'");
            }
        }
    }

    DefaultFactHandle bufferInsertMultiple(Object fact, boolean applyToStorage, boolean resolveCollections, WorkMemoryActionBuffer destination) {
        Collection<?> rawFacts = AbstractRuleSessionOps.factToCollection(fact, resolveCollections);
        return this.bufferInsertMultiple(rawFacts, applyToStorage, destination);
    }

    DefaultFactHandle bufferInsertMultiple(String type, Object fact, boolean applyToStorage, boolean resolveCollections, WorkMemoryActionBuffer destination) {
        Collection<?> rawFacts = AbstractRuleSessionOps.factToCollection(fact, resolveCollections);
        return this.bufferInsertMultiple(rawFacts, applyToStorage, type, destination);
    }

    private DefaultFactHandle bufferInsertMultiple(Collection<?> facts, boolean applyToStorage, String logicalType, WorkMemoryActionBuffer destination) {
        TypeResolver typeResolver = this.getTypeResolver();
        Type factType = typeResolver.getType(Objects.requireNonNull(logicalType, "Null fact type is not allowed"));
        if (factType == null) {
            if (this.warnUnknownTypes) {
                LOGGER.warning(() -> "Unknown type '" + logicalType + "', insert operation skipped.");
            }
            return null;
        }
        ActiveType type = this.getCreateIndexedType(factType);
        DefaultFactHandle last = null;
        for (Object fact : facts) {
            last = this.bufferInsertSingle(factType, type, applyToStorage, fact, destination);
        }
        return facts.size() == 1 ? last : null;
    }

    private DefaultFactHandle bufferInsertMultiple(Collection<?> facts, boolean applyToStorage, WorkMemoryActionBuffer destination) {
        TypeResolver typeResolver = this.getTypeResolver();
        DefaultFactHandle last = null;
        int count = 0;
        for (Object fact : facts) {
            if (fact == null) continue;
            Type factType = typeResolver.resolve(fact);
            if (factType == null) {
                if (!this.warnUnknownTypes) continue;
                LOGGER.warning(() -> "Can not map type for '" + fact.getClass().getName() + "', insert operation skipped.");
                continue;
            }
            ActiveType type = this.getCreateIndexedType(factType);
            last = this.bufferInsertSingle(factType, type, applyToStorage, fact, destination);
            ++count;
        }
        return count == 1 ? last : null;
    }

    DefaultFactHandle bufferInsertSingle(Type<?> type, ActiveType activeType, boolean applyToStorage, Object fact, WorkMemoryActionBuffer destination) {
        DefaultFactHandle factHandle = new DefaultFactHandle(activeType.getId());
        this.bufferInsertSingle(factHandle, type, activeType, applyToStorage, fact, destination);
        return factHandle;
    }

    private void bufferInsertSingle(DefaultFactHandle factHandle, Type<?> type, ActiveType activeType, boolean applyToStorage, Object fact, WorkMemoryActionBuffer destination) {
        TypeMemory memory = this.getMemory().getTypeMemory(activeType.getId());
        ValueIndexer<FactFieldValues> valueIndexer = memory.getFieldValuesIndexer();
        FactFieldValues fieldValues = activeType.readFactValue(type, fact);
        long valuesId = valueIndexer.getOrCreateId(fieldValues);
        FactHolder factHolder = new FactHolder(factHandle, valuesId, fact);
        if (applyToStorage) {
            memory.insert(factHolder);
        }
        destination.addInsert(new DeltaMemoryAction.Insert(activeType, factHolder, fieldValues, !applyToStorage));
        LOGGER.finer(() -> "New insert action buffered for fact: " + String.valueOf(fact));
    }

    private static Collection<?> factToCollection(Object fact, boolean resolveCollections) {
        Object f = Objects.requireNonNull(fact, "Null facts are not allowed");
        return resolveCollections ? CommonUtils.toCollection(f) : Collections.singleton(f);
    }

    Collection<AlphaAddress> matchingAlphaLocations(DefaultFactHandle handle, FactFieldValues values) {
        ActiveType activeType = this.getActiveType(handle);
        Mask<AlphaConditionHandle> alphaConditionResults = this.alphaConditionResults(activeType, values);
        return AlphaAddress.matchingLocations(alphaConditionResults, activeType.getKnownAlphaLocations());
    }

    Mask<AlphaConditionHandle> alphaConditionResults(ActiveType activeType, FactFieldValues values) {
        Mask<AlphaConditionHandle> alphaConditionResults = Mask.alphaConditionsMask();
        ActiveEvaluatorGenerator context = this.getEvaluatorsContext();
        activeType.forEachAlphaCondition(indexedHandle -> {
            StoredCondition evaluator = context.get(indexedHandle.getHandle(), false);
            ActiveField activeField = (ActiveField)evaluator.getDescriptor().get(0).field();
            IntToValue args = index -> values.valueAt(activeField.valueIndex());
            alphaConditionResults.set((AlphaConditionHandle)indexedHandle, evaluator.test(this, args));
        });
        return alphaConditionResults;
    }
}

