/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.time.Instant;
import org.evrete.KnowledgeService;
import org.evrete.api.Imports;
import org.evrete.api.RuntimeContext;
import org.evrete.api.TypeResolver;
import org.evrete.api.events.ContextEvent;
import org.evrete.api.events.EnvironmentChangeEvent;
import org.evrete.api.events.Events;
import org.evrete.runtime.EventMessageBus;
import org.evrete.util.AbstractEnvironment;

abstract class AbstractRuntimeBase<C extends RuntimeContext<C>>
extends AbstractEnvironment
implements RuntimeContext<C> {
    private final Imports imports;
    private final ClassLoader classloader;
    private final TypeResolver typeResolver;
    private final KnowledgeService service;
    private final EventMessageBus messageBus;
    private final Instant contextCreateStartTime = Instant.now();

    AbstractRuntimeBase(KnowledgeService service) {
        super(service.getConfiguration());
        ClassLoader classLoader;
        this.service = service;
        this.imports = service.getConfiguration().getImports().copyOf();
        this.classloader = classLoader = service.getClassLoader();
        this.typeResolver = service.getTypeResolverProvider().instance(classLoader);
        this.messageBus = service.getMessageBus().copyOf();
    }

    AbstractRuntimeBase(AbstractRuntimeBase<?> parent) {
        super(parent);
        this.imports = parent.imports.copyOf();
        this.service = parent.service;
        this.classloader = parent.classloader;
        this.typeResolver = (TypeResolver)parent.typeResolver.copyOf();
        this.messageBus = parent.messageBus.copyOf();
    }

    public Instant getContextCreateStartTime() {
        return this.contextCreateStartTime;
    }

    abstract void _assertActive();

    EventMessageBus getMessageBus() {
        return this.messageBus;
    }

    protected <E extends ContextEvent> void broadcast(Class<E> type, E event) {
        this.messageBus.broadcast(type, event);
    }

    @Override
    public <E extends ContextEvent> Events.Publisher<E> getPublisher(Class<E> eventClass) {
        return this.messageBus.getPublisher(eventClass);
    }

    @Override
    public final C set(final String property, final Object value) {
        super.set(property, value);
        this.broadcast(EnvironmentChangeEvent.class, new EnvironmentChangeEvent(){

            @Override
            public String getProperty() {
                return property;
            }

            @Override
            public Object getValue() {
                return value;
            }
        });
        return (C)this;
    }

    @Override
    public final C addImport(String imp) {
        this.imports.add(imp);
        return (C)this;
    }

    @Override
    public final Imports getImports() {
        return this.imports;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    @Override
    public KnowledgeService getService() {
        return this.service;
    }
}

