/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.DeltaMemoryAction;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.MapOfList;
import org.evrete.runtime.Mask;
import org.evrete.runtime.SessionFactGroup;
import org.evrete.runtime.SessionLhs;
import org.evrete.runtime.SessionMemory;
import org.evrete.runtime.SessionRule;
import org.evrete.runtime.TypeAlphaMemory;
import org.evrete.runtime.TypeMemory;
import org.evrete.runtime.WorkMemoryActionBuffer;
import org.evrete.util.CommonUtils;

class ActivationContext {
    private static final Logger LOGGER = Logger.getLogger(ActivationContext.class.getName());
    private final AtomicInteger activationCount = new AtomicInteger();
    private final SessionMemory memory;
    private final List<SessionRule> rules;
    private final ExecutorService executor;
    private final AbstractRuleSession<?> session;

    public ActivationContext(AbstractRuleSession<?> session, List<SessionRule> rules) {
        this.session = session;
        this.memory = session.getMemory();
        this.executor = session.getService().getExecutor();
        this.rules = Collections.unmodifiableList(rules);
    }

    int incrementFireCount() {
        return this.activationCount.incrementAndGet();
    }

    CompletableFuture<Status> computeDelta(WorkMemoryActionBuffer actions) {
        int bufferedCount = actions.bufferedActionCount();
        LOGGER.fine(() -> "Computing delta memory from [" + bufferedCount + "] actions");
        return actions.sinkToSplitView(this.executor).thenCompose(typedActions -> this.processDeleteActions((Collection<WorkMemoryActionBuffer.SplitView>)typedActions).thenCompose(unused -> this.processDeltaStatus((Collection<WorkMemoryActionBuffer.SplitView>)typedActions)));
    }

    private CompletableFuture<Void> processDeleteActions(Collection<WorkMemoryActionBuffer.SplitView> typedActions) {
        if (typedActions.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        MapOfList<TypeAlphaMemory, List> deletesByAlphaMemory = new MapOfList<TypeAlphaMemory, List>();
        MapOfList<TypeMemory, Object> nonAppliedDeletes = new MapOfList<TypeMemory, Object>();
        MapOfList<SessionFactGroup, Object> deletesByFactGroups = new MapOfList<SessionFactGroup, Object>();
        for (WorkMemoryActionBuffer.SplitView view : typedActions) {
            ActiveType type = view.getType();
            Collection<DeltaMemoryAction.Delete> deleteOps = view.getDeletes();
            TypeMemory typeMemory = this.memory.getTypeMemory(type.getId());
            for (DeltaMemoryAction.Delete op : deleteOps) {
                DefaultFactHandle handle = op.getHandle();
                FactHolder factHolder = op.getFactWrapper();
                if (op.applyToMemory()) {
                    nonAppliedDeletes.add(typeMemory, handle);
                }
                type.forEachAlphaAddress(alphaAddress -> {
                    TypeAlphaMemory alphaMemory = this.memory.getAlphaMemory((AlphaAddress)alphaAddress);
                    deletesByAlphaMemory.add(alphaMemory, (List)((Object)factHolder));
                });
                for (SessionRule rule : this.rules) {
                    for (SessionFactGroup group2 : (SessionFactGroup[])((SessionLhs)rule.getLhs()).getFactGroups()) {
                        if (group2.isPlain() || !group2.getTypeMask().get(type)) continue;
                        deletesByFactGroups.add(group2, factHolder);
                    }
                }
            }
        }
        ArrayList deleteFutures = new ArrayList();
        LOGGER.fine(() -> "Scheduling delete ops: alpha memories: [" + deletesByAlphaMemory.size() + "], type memories: [" + nonAppliedDeletes.size() + "],  fact groups: [" + deletesByFactGroups.size() + "]");
        deletesByAlphaMemory.forEach((memory, value) -> deleteFutures.add(this.processDeleteDeltaActions((TypeAlphaMemory)memory, (Collection<FactHolder>)value)));
        nonAppliedDeletes.forEach((memory, factWrappers) -> deleteFutures.add(this.handleNonAppliedDeletes((TypeMemory)memory, (Collection<DefaultFactHandle>)factWrappers)));
        deletesByFactGroups.forEach((group, ops) -> deleteFutures.add(group.processDeleteDeltaActions((Collection<FactHolder>)ops)));
        return CommonUtils.completeAll(deleteFutures);
    }

    private CompletableFuture<Status> processDeltaStatus(Collection<WorkMemoryActionBuffer.SplitView> typedActions) {
        if (typedActions.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Status result = new Status();
        MapOfList<AlphaAddress, FactHolder> insertsByAlphaLocation = new MapOfList<AlphaAddress, FactHolder>();
        MapOfList<ActiveType.Idx, FactHolder> nonAppliedByTypeMemory = new MapOfList<ActiveType.Idx, FactHolder>();
        for (WorkMemoryActionBuffer.SplitView splitView : typedActions) {
            ActiveType type = splitView.getType();
            Collection<DeltaMemoryAction.Insert> insertOps = splitView.getInserts();
            LOGGER.fine(() -> "Start processing [" + insertOps.size() + "] insert ops of type: " + String.valueOf(type.getId()));
            for (DeltaMemoryAction.Insert insert : insertOps) {
                FactHolder factHolder = insert.getFactWrapper();
                Collection<AlphaAddress> matchingAlphaLocations = this.session.matchingAlphaLocations(insert.getHandle(), insert.getValues());
                for (AlphaAddress matchingAlpha : matchingAlphaLocations) {
                    insertsByAlphaLocation.add(matchingAlpha, factHolder);
                }
                if (!insert.applyToMemory()) continue;
                nonAppliedByTypeMemory.add(insert.getHandle().getType(), factHolder);
            }
        }
        LinkedList insertFutures = new LinkedList();
        for (Map.Entry entry : insertsByAlphaLocation.entrySet()) {
            AlphaAddress alpha = (AlphaAddress)entry.getKey();
            List inserts = (List)entry.getValue();
            TypeAlphaMemory alphaMemory = this.memory.getAlphaMemory(alpha);
            LOGGER.fine(() -> "Scheduling [" + inserts.size() + "] inserts into alpha memory: " + String.valueOf(alpha));
            insertFutures.add(this.processInsertDeltaActions(alphaMemory, inserts));
            result.addAffectedAlphaBucket(alphaMemory);
        }
        for (Map.Entry entry : nonAppliedByTypeMemory.entrySet()) {
            ActiveType.Idx type = (ActiveType.Idx)entry.getKey();
            TypeMemory typeMemory = this.memory.getTypeMemory(type);
            List facts = (List)entry.getValue();
            LOGGER.fine(() -> "Scheduling saves into fact storage: " + String.valueOf(type) + ", fact count: " + facts.size());
            insertFutures.add(this.handleNonAppliedInserts(typeMemory, facts));
        }
        Mask<AlphaAddress> mask = Mask.alphaAddressMask().set(insertsByAlphaLocation.keySet());
        for (SessionRule rule : this.rules) {
            boolean ruleAdded = false;
            for (SessionFactGroup group : (SessionFactGroup[])((SessionLhs)rule.getLhs()).getFactGroups()) {
                if (!group.getAlphaAddressMask().intersects(mask)) continue;
                result.addAffectedFactGroup(group);
                if (ruleAdded) continue;
                result.addAffectedRule(rule);
                ruleAdded = true;
            }
        }
        return CommonUtils.completeAll(insertFutures).thenComposeAsync(unused -> CommonUtils.completeAll(result.affectedFactGroups, group -> group.buildDeltas(DeltaMemoryMode.DEFAULT)).thenApply(unused1 -> result), (Executor)this.executor);
    }

    CompletableFuture<Void> commitMemories(Status status) {
        LOGGER.fine(() -> "Scheduling memory commits. Fact groups: " + status.affectedFactGroups.size() + ", alpha memories: " + status.affectedAlphaBuckets.size());
        ArrayList commitFutures = new ArrayList();
        for (SessionFactGroup group : status.affectedFactGroups) {
            commitFutures.add(group.commitDeltas());
        }
        for (TypeAlphaMemory alphaMemory : status.affectedAlphaBuckets) {
            commitFutures.add(alphaMemory.commit(this.executor));
        }
        return CommonUtils.completeAll(commitFutures);
    }

    CompletableFuture<Void> handleNonAppliedInserts(TypeMemory typeMemory, Collection<FactHolder> facts) {
        return CompletableFuture.runAsync(() -> {
            for (FactHolder fact : facts) {
                typeMemory.insert(fact);
            }
        }, this.executor);
    }

    CompletableFuture<Void> handleNonAppliedDeletes(TypeMemory typeMemory, Collection<DefaultFactHandle> facts) {
        return CompletableFuture.runAsync(() -> {
            for (DefaultFactHandle handle : facts) {
                typeMemory.remove(handle);
            }
        }, this.executor);
    }

    CompletableFuture<Void> processDeleteDeltaActions(TypeAlphaMemory memory, Collection<FactHolder> deletes) {
        return CompletableFuture.runAsync(() -> {
            for (FactHolder delete : deletes) {
                memory.delete(delete.getFieldValuesId(), delete.getHandle());
            }
        }, this.executor);
    }

    CompletableFuture<Void> processInsertDeltaActions(TypeAlphaMemory memory, Collection<FactHolder> inserts) {
        return CompletableFuture.runAsync(() -> {
            for (FactHolder insert : inserts) {
                memory.insert(insert.getFieldValuesId(), insert.getHandle());
            }
        }, this.executor);
    }

    static class Status {
        final List<SessionRule> agenda = new LinkedList<SessionRule>();
        final List<SessionFactGroup> affectedFactGroups = new LinkedList<SessionFactGroup>();
        final List<TypeAlphaMemory> affectedAlphaBuckets = new LinkedList<TypeAlphaMemory>();

        Status() {
        }

        List<SessionRule> getAgenda() {
            return this.agenda;
        }

        void addAffectedRule(SessionRule sessionRule) {
            this.agenda.add(sessionRule);
        }

        void addAffectedFactGroup(SessionFactGroup sessionFactGroup) {
            this.affectedFactGroups.add(sessionFactGroup);
        }

        void addAffectedAlphaBucket(TypeAlphaMemory typeAlphaMemory) {
            this.affectedAlphaBuckets.add(typeAlphaMemory);
        }
    }
}

