/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Objects;
import org.evrete.api.TypeField;
import org.evrete.runtime.ActiveType;
import org.evrete.util.AbstractIndex;

public final class ActiveField {
    private final ActiveType.Idx type;
    private final int valueIndex;
    private final String name;
    private final Class<?> valueType;

    public ActiveField(ActiveType.Idx type, TypeField delegate, int valueIndex) {
        this.type = type;
        this.name = delegate.getName();
        this.valueIndex = valueIndex;
        this.valueType = delegate.getValueType();
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public String getName() {
        return this.name;
    }

    public int valueIndex() {
        return this.valueIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveField that = (ActiveField)o;
        return this.type.getIndex() == that.type.getIndex() && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.type.getIndex() * 37 + this.valueIndex;
    }

    public String toString() {
        return "{'" + this.getName() + "'/" + String.valueOf(this.getValueType()) + ", ofType=" + String.valueOf(this.type) + ", valueIdx=" + this.valueIndex + "}";
    }

    static class Index
    extends AbstractIndex {
        public Index(int index) {
            super(index, index);
        }
    }
}

