/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.Mask;
import org.evrete.runtime.PreHashed;
import org.evrete.runtime.TypeAlphaConditions;
import org.evrete.runtime.evaluation.AlphaConditionHandle;
import org.evrete.util.Indexed;

public class AlphaAddress
extends PreHashed
implements Indexed {
    private final int index;
    private final TypeAlphaConditions typeAlphaConditions;

    public AlphaAddress(int index, TypeAlphaConditions typeAlphaConditions) {
        super(index);
        this.index = index;
        this.typeAlphaConditions = typeAlphaConditions;
    }

    private Mask<AlphaConditionHandle> getMask() {
        return this.typeAlphaConditions.getMask();
    }

    public ActiveType.Idx getType() {
        return this.typeAlphaConditions.getType();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "{idx=" + this.index + ", alpha=" + String.valueOf(this.typeAlphaConditions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlphaAddress that = (AlphaAddress)o;
        return this.index == that.index;
    }

    public boolean matches(Mask<AlphaConditionHandle> alphaConditionResults) {
        return alphaConditionResults.containsAll(this.getMask());
    }

    public static Collection<AlphaAddress> matchingLocations(Mask<AlphaConditionHandle> alphaConditionResults, Set<AlphaAddress> scope) {
        ArrayList<AlphaAddress> matching = new ArrayList<AlphaAddress>(scope.size());
        for (AlphaAddress alphaAddress : scope) {
            if (!alphaAddress.matches(alphaConditionResults)) continue;
            matching.add(alphaAddress);
        }
        return matching;
    }
}

