/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.FactType;
import org.evrete.runtime.Mask;
import org.evrete.runtime.rete.ReteGraph;
import org.evrete.runtime.rete.ReteKnowledgeConditionNode;
import org.evrete.runtime.rete.ReteKnowledgeEntryNode;
import org.evrete.runtime.rete.ReteKnowledgeNode;

public abstract class KnowledgeFactGroup {
    public static final KnowledgeFactGroup[] EMPTY_ARRAY = new KnowledgeFactGroup[0];
    private final FactType[] entryNodes;
    private final Mask<ActiveType> typeMask;
    private final Mask<AlphaAddress> alphaAddressMask;

    public KnowledgeFactGroup(FactType[] entryNodes) {
        this.entryNodes = entryNodes;
        this.typeMask = Mask.typeMask();
        this.alphaAddressMask = Mask.alphaAddressMask();
        for (FactType entryNode : entryNodes) {
            ActiveType type = entryNode.type();
            this.typeMask.set(type);
            this.alphaAddressMask.set(entryNode.getAlphaAddress());
        }
    }

    public Mask<AlphaAddress> getAlphaAddressMask() {
        return this.alphaAddressMask;
    }

    public KnowledgeFactGroup(KnowledgeFactGroup other) {
        this.entryNodes = other.getEntryNodes();
        this.typeMask = other.typeMask;
        this.alphaAddressMask = other.alphaAddressMask;
    }

    public Mask<ActiveType> getTypeMask() {
        return this.typeMask;
    }

    public FactType[] getEntryNodes() {
        return this.entryNodes;
    }

    public static KnowledgeFactGroup fromPlainFactTypes(FactType[] factTypes) {
        return new Plain(factTypes);
    }

    public static KnowledgeFactGroup fromTerminalCondition(ReteKnowledgeConditionNode terminalNode) {
        ReteGraph<ReteKnowledgeNode, ReteKnowledgeEntryNode, ReteKnowledgeConditionNode> graph = ReteGraph.fromTerminalNode(terminalNode);
        return new Beta(graph);
    }

    static class Plain
    extends KnowledgeFactGroup {
        Plain(FactType[] factTypes) {
            super(factTypes);
        }
    }

    static class Beta
    extends KnowledgeFactGroup {
        private final ReteGraph<ReteKnowledgeNode, ReteKnowledgeEntryNode, ReteKnowledgeConditionNode> graph;

        Beta(ReteGraph<ReteKnowledgeNode, ReteKnowledgeEntryNode, ReteKnowledgeConditionNode> graph) {
            super(graph.terminalNode().getNodeFactTypes());
            this.graph = graph;
        }

        public ReteGraph<ReteKnowledgeNode, ReteKnowledgeEntryNode, ReteKnowledgeConditionNode> getGraph() {
            return this.graph;
        }
    }
}

