/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.evrete.runtime.AbstractLhsFact;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeFactGroup;
import org.evrete.runtime.Mask;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.rete.ReteKnowledgeConditionNode;
import org.evrete.runtime.rete.ReteKnowledgeEntryNode;
import org.evrete.runtime.rete.ReteKnowledgeNode;
import org.evrete.util.MapFunction;

public final class KnowledgeFactGroupBuilder {
    private static final Logger LOGGER = Logger.getLogger(KnowledgeFactGroupBuilder.class.getName());

    static KnowledgeFactGroup[] build(Collection<FactType> factTypes, Collection<BetaEvaluator> flattenedBetaConditions) {
        ArrayList<BetaEvaluator> betaEvaluators = new ArrayList<BetaEvaluator>(flattenedBetaConditions);
        betaEvaluators.sort(BetaEvaluator::compare);
        LOGGER.fine(() -> "Building fact groups for fact types: " + FactType.toSimpleDebugString(factTypes) + " and beta conditions: " + String.valueOf(flattenedBetaConditions));
        ArrayList<FactTypeNode> unallocatedEntryNodes = new ArrayList<FactTypeNode>(factTypes.size());
        for (FactType factType : factTypes) {
            unallocatedEntryNodes.add(new FactTypeNode(factType));
        }
        LinkedList<EvaluatorNode> unallocatedConditionNodes = new LinkedList<EvaluatorNode>();
        for (BetaEvaluator evaluator : betaEvaluators) {
            Mask<FactType> m2;
            LOGGER.fine(() -> "1. Processing " + String.valueOf(evaluator) + "...");
            Mask<FactType> evaluatorMask = evaluator.getTypeMask();
            LinkedList<FactTypeNode> evaluatorEntryNodes = new LinkedList<FactTypeNode>();
            Iterator it1 = unallocatedEntryNodes.iterator();
            while (it1.hasNext()) {
                FactTypeNode factTypeNode = (FactTypeNode)it1.next();
                if (!factTypeNode.intersects(evaluatorMask)) continue;
                evaluatorEntryNodes.add(factTypeNode);
                it1.remove();
            }
            LOGGER.fine(() -> "2. Matching entry nodes " + String.valueOf(evaluatorEntryNodes));
            LinkedList<EvaluatorNode> evaluatorConditionNodes = new LinkedList<EvaluatorNode>();
            Iterator it2 = unallocatedConditionNodes.iterator();
            while (it2.hasNext()) {
                EvaluatorNode evaluatorNode = (EvaluatorNode)it2.next();
                if (!evaluatorNode.intersects(evaluatorMask)) continue;
                evaluatorConditionNodes.add(evaluatorNode);
                it2.remove();
            }
            LOGGER.fine(() -> "3. Matching condition nodes " + String.valueOf(evaluatorConditionNodes));
            if (evaluatorConditionNodes.size() + evaluatorEntryNodes.size() < 1) {
                throw new IllegalStateException("Unable to allocate fact types: invalid sources");
            }
            Mask<FactType> m1 = KnowledgeFactGroupBuilder.maskOf(evaluatorConditionNodes);
            if (m1.intersects(m2 = KnowledgeFactGroupBuilder.maskOf(evaluatorEntryNodes))) {
                throw new IllegalStateException("Unable to allocate fact types: intersecting sources");
            }
            unallocatedConditionNodes.removeAll(evaluatorConditionNodes);
            unallocatedEntryNodes.removeAll(evaluatorEntryNodes);
            EvaluatorNode evaluatorNode = new EvaluatorNode(evaluator, evaluatorEntryNodes, evaluatorConditionNodes);
            unallocatedConditionNodes.add(evaluatorNode);
        }
        return KnowledgeFactGroupBuilder.arrange(unallocatedEntryNodes, unallocatedConditionNodes);
    }

    private static KnowledgeFactGroup[] arrange(List<FactTypeNode> unallocatedEntryNodes, List<EvaluatorNode> unallocatedNodes) {
        LinkedList<KnowledgeFactGroup> resultList = new LinkedList<KnowledgeFactGroup>();
        List unallocatedTypes = unallocatedEntryNodes.stream().map(FactTypeNode::getFactType).sorted(Comparator.comparingInt(AbstractLhsFact::getInRuleIndex)).collect(Collectors.toList());
        int unallocatedSize = unallocatedTypes.size();
        if (unallocatedSize > 0) {
            FactType[] groupedFactTypes = new FactType[unallocatedSize];
            for (int i = 0; i < unallocatedSize; ++i) {
                FactType factType;
                groupedFactTypes[i] = factType = (FactType)unallocatedTypes.get(i);
            }
            resultList.add(KnowledgeFactGroup.fromPlainFactTypes(groupedFactTypes));
        }
        for (EvaluatorNode evaluatorNode : unallocatedNodes) {
            resultList.add(KnowledgeFactGroupBuilder.betaGroup(evaluatorNode));
        }
        return resultList.toArray(KnowledgeFactGroup.EMPTY_ARRAY);
    }

    private static KnowledgeFactGroup betaGroup(EvaluatorNode terminalNode) {
        ArrayList<FactType> entryNodes = new ArrayList<FactType>();
        terminalNode.forEachEntryNodeSource(node -> entryNodes.add(node.factType));
        int totalEntryNodes = entryNodes.size();
        assert (totalEntryNodes > 0);
        entryNodes.sort(Comparator.comparingInt(AbstractLhsFact::getInRuleIndex));
        MapFunction<FactType, ReteKnowledgeEntryNode> entryNodeMapping = new MapFunction<FactType, ReteKnowledgeEntryNode>();
        for (int i = 0; i < totalEntryNodes; ++i) {
            FactType nodeFactType = (FactType)entryNodes.get(i);
            ReteKnowledgeEntryNode reteEntryNode = new ReteKnowledgeEntryNode(nodeFactType);
            entryNodeMapping.putNew(nodeFactType, reteEntryNode);
        }
        ReteKnowledgeConditionNode reteTerminalNode = terminalNode.toReteNode(entryNodeMapping);
        return KnowledgeFactGroup.fromTerminalCondition(reteTerminalNode);
    }

    private static Mask<FactType> ofConditionNodeComponents(Collection<FactTypeNode> evaluatorEntryNodes, Collection<EvaluatorNode> evaluatorConditionNodes) {
        Mask<FactType> total = Mask.factTypeMask();
        for (FactTypeNode factTypeNode : evaluatorEntryNodes) {
            total.or(factTypeNode.factTypeMask);
        }
        for (EvaluatorNode evaluatorNode : evaluatorConditionNodes) {
            total.or(evaluatorNode.factTypeMask);
        }
        return total;
    }

    private static Mask<FactType> maskOf(FactType factType) {
        return Mask.factTypeMask().set(factType);
    }

    private static Mask<FactType> maskOf(Collection<? extends Node> nodes) {
        Mask<FactType> mask = Mask.factTypeMask();
        for (Node node : nodes) {
            mask.or(node.factTypeMask);
        }
        return mask;
    }

    private static class FactTypeNode
    extends Node {
        private final FactType factType;

        public FactTypeNode(FactType factType) {
            super(KnowledgeFactGroupBuilder.maskOf(factType));
            this.factType = factType;
        }

        public FactType getFactType() {
            return this.factType;
        }

        public String toString() {
            return "Node{factType='" + this.factType.getVarName() + "'}";
        }
    }

    private static class EvaluatorNode
    extends Node {
        final BetaEvaluator evaluator;
        final Collection<FactTypeNode> entryNodeSources;
        final Collection<EvaluatorNode> conditionNodeSources;

        EvaluatorNode(BetaEvaluator evaluator, Collection<FactTypeNode> entryNodeSources, Collection<EvaluatorNode> conditionNodeSources) {
            super(KnowledgeFactGroupBuilder.ofConditionNodeComponents(entryNodeSources, conditionNodeSources));
            this.evaluator = evaluator;
            this.conditionNodeSources = conditionNodeSources;
            this.entryNodeSources = entryNodeSources;
        }

        void forEachEntryNodeSource(Consumer<FactTypeNode> consumer) {
            this.entryNodeSources.forEach(consumer);
            for (EvaluatorNode evaluatorNode : this.conditionNodeSources) {
                evaluatorNode.forEachEntryNodeSource(consumer);
            }
        }

        ReteKnowledgeConditionNode toReteNode(MapFunction<FactType, ReteKnowledgeEntryNode> entryNodeMapping) {
            ArrayList<ReteKnowledgeNode> sourceNodes = new ArrayList<ReteKnowledgeNode>();
            for (FactTypeNode factTypeNode : this.entryNodeSources) {
                sourceNodes.add(entryNodeMapping.apply(factTypeNode.factType));
            }
            for (EvaluatorNode conditionNode : this.conditionNodeSources) {
                sourceNodes.add(conditionNode.toReteNode(entryNodeMapping));
            }
            return new ReteKnowledgeConditionNode(this.evaluator, sourceNodes.toArray(ReteKnowledgeNode.EMPTY_ARRAY));
        }

        public String toString() {
            return "Node{evaluator=" + String.valueOf(this.evaluator) + "}";
        }
    }

    private static class Node {
        final Mask<FactType> factTypeMask;

        Node(Mask<FactType> factTypeMask) {
            this.factTypeMask = factTypeMask;
        }

        boolean intersects(Mask<FactType> other) {
            return this.factTypeMask.intersects(other);
        }
    }
}

