/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import org.evrete.runtime.ActiveLhs;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeFactGroup;
import org.evrete.runtime.KnowledgeFactGroupBuilder;
import org.evrete.runtime.RuleBuilderActiveConditions;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.util.MapFunction;

class KnowledgeLhs
extends ActiveLhs<KnowledgeFactGroup> {
    private final MapFunction<String, FactPosition> factPositionMapping;

    public KnowledgeLhs(KnowledgeFactGroup[] factGroups) {
        super(factGroups);
        MapFunction<String, FactPosition> mapFunction = new MapFunction<String, FactPosition>();
        KnowledgeFactGroup[] groups = this.getFactGroups();
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            KnowledgeFactGroup group = groups[groupIndex];
            FactType[] factTypes = group.getEntryNodes();
            for (int inGroupIndex = 0; inGroupIndex < factTypes.length; ++inGroupIndex) {
                FactType factType = factTypes[inGroupIndex];
                String varName = factType.getVarName();
                FactPosition factPosition = new FactPosition(groupIndex, inGroupIndex, factType.getInRuleIndex());
                mapFunction.putNew(varName, factPosition);
            }
        }
        this.factPositionMapping = mapFunction;
    }

    MapFunction<String, FactPosition> getFactPositionMapping() {
        return this.factPositionMapping;
    }

    public static KnowledgeLhs factory(Collection<FactType> factTypes, RuleBuilderActiveConditions lhsConditions) {
        Collection<BetaEvaluator> flattenedBetaConditions = lhsConditions.flattenBetaConditions(factTypes);
        KnowledgeFactGroup[] factGroups = KnowledgeFactGroupBuilder.build(factTypes, flattenedBetaConditions);
        return new KnowledgeLhs(factGroups);
    }

    static class FactPosition {
        final int groupIndex;
        final int inGroupIndex;
        final int inRuleIndex;

        FactPosition(int groupIndex, int inGroupIndex, int inRuleIndex) {
            this.groupIndex = groupIndex;
            this.inGroupIndex = inGroupIndex;
            this.inRuleIndex = inRuleIndex;
        }
    }
}

