/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.RuleDescriptor;
import org.evrete.api.RuleSession;
import org.evrete.api.StatefulSession;
import org.evrete.api.StatelessSession;
import org.evrete.api.events.KnowledgeCreatedEvent;
import org.evrete.runtime.AbstractRuntime;
import org.evrete.runtime.KnowledgeRule;
import org.evrete.runtime.SearchList;
import org.evrete.runtime.StatefulSessionImpl;
import org.evrete.runtime.StatelessSessionImpl;
import org.evrete.runtime.events.KnowledgeCreatedEventImpl;

public class KnowledgeRuntime
extends AbstractRuntime<RuleDescriptor, Knowledge>
implements Knowledge {
    private final WeakHashMap<RuleSession<?>, Object> sessions = new WeakHashMap();
    private final Object VALUE = new Object();
    private final SearchList<KnowledgeRule> ruleDescriptors = new SearchList();

    public KnowledgeRuntime(KnowledgeService service, String name) {
        super(service, name);
        this.broadcast(KnowledgeCreatedEvent.class, new KnowledgeCreatedEventImpl(this.getContextCreateStartTime(), this));
    }

    @Override
    void addRuleDescriptors(List<KnowledgeRule> descriptors) {
        if (!descriptors.isEmpty()) {
            for (KnowledgeRule rd : descriptors) {
                this.ruleDescriptors.add(rd);
            }
            this.ruleDescriptors.sort(this.getRuleComparator());
        }
    }

    @Override
    public List<RuleDescriptor> getRules() {
        return Collections.unmodifiableList(this.ruleDescriptors.getList());
    }

    List<KnowledgeRule> getRuleDescriptors() {
        return Collections.unmodifiableList(this.ruleDescriptors.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(RuleSession<?> session) {
        WeakHashMap<RuleSession<?>, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            this.sessions.remove(session);
        }
    }

    @Override
    void _assertActive() {
    }

    @Override
    public KnowledgeRule getRule(String name) {
        return this.ruleDescriptors.get(name);
    }

    @Override
    public Collection<RuleSession<?>> getSessions() {
        return Collections.unmodifiableCollection(this.sessions.keySet());
    }

    @Override
    public StatefulSession newStatefulSession() {
        return this.register(new StatefulSessionImpl(this));
    }

    @Override
    public StatelessSession newStatelessSession() {
        return this.register(new StatelessSessionImpl(this));
    }

    private <S extends RuleSession<S>> S register(S session) {
        this.sessions.put(session, this.VALUE);
        return session;
    }
}

