/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.evrete.api.FactHandle;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.AbstractRuleSessionOps;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.KnowledgeLhs;
import org.evrete.runtime.SessionFactGroup;
import org.evrete.runtime.SessionRule;
import org.evrete.runtime.WorkMemoryActionBuffer;
import org.evrete.util.MapFunction;

class RhsContextImpl
implements RhsContext {
    private static final Logger LOGGER = Logger.getLogger(RhsContextImpl.class.getName());
    private final CachedFactEntry[] cache;
    private final DefaultFactHandle[][] currentState;
    private final MapFunction<String, KnowledgeLhs.FactPosition> factPositions;
    private final SessionFactGroup[] factGroups;
    private final SessionRule rule;
    private final WorkMemoryActionBuffer destinationForRuleActions;
    final AtomicLong activationCount = new AtomicLong();

    public RhsContextImpl(SessionRule rule, DefaultFactHandle[][] currentGroupedFacts, MapFunction<String, KnowledgeLhs.FactPosition> factPositions, SessionFactGroup[] factGroups, WorkMemoryActionBuffer destinationForRuleActions) {
        this.cache = new CachedFactEntry[factPositions.size()];
        this.currentState = currentGroupedFacts;
        this.factPositions = factPositions;
        this.factGroups = factGroups;
        this.rule = rule;
        this.destinationForRuleActions = destinationForRuleActions;
    }

    RhsContext next() {
        LOGGER.finer(() -> "Rule '" + this.rule.getName() + "', current RHS handles: " + Arrays.deepToString((Object[])this.currentState));
        Arrays.fill(this.cache, null);
        this.activationCount.incrementAndGet();
        return this;
    }

    private Object currentFactByFactName(String varName) {
        KnowledgeLhs.FactPosition pos = this.factPositions.apply(varName);
        int inRuleIndex = pos.inRuleIndex;
        CachedFactEntry cachedFactEntry = this.cache[inRuleIndex];
        if (cachedFactEntry == null) {
            DefaultFactHandle handle = this.currentState[pos.groupIndex][pos.inGroupIndex];
            FactHolder wrapper = this.factGroups[pos.groupIndex].factTypes[pos.inGroupIndex].getFact(handle);
            this.cache[inRuleIndex] = new CachedFactEntry(wrapper, handle);
            return wrapper.getFact();
        }
        return cachedFactEntry.wrapper.getFact();
    }

    private CachedFactEntry findByFact(Object fact) {
        for (CachedFactEntry entry : this.cache) {
            if (entry == null || entry.wrapper.getFact() != fact) continue;
            return entry;
        }
        return null;
    }

    @Override
    public FactHandle insert0(Object fact, boolean resolveCollections) {
        return ((AbstractRuleSessionOps)this.rule.getRuntime()).bufferInsertMultiple(fact, false, resolveCollections, this.destinationForRuleActions);
    }

    @Override
    public FactHandle insert0(String type, Object fact, boolean resolveCollections) {
        return ((AbstractRuleSessionOps)this.rule.getRuntime()).bufferInsertMultiple(type, fact, false, resolveCollections, this.destinationForRuleActions);
    }

    @Override
    public void delete(FactHandle handle) {
        ((AbstractRuleSessionOps)this.rule.getRuntime()).bufferDelete(handle, false, this.destinationForRuleActions);
    }

    @Override
    public void update(FactHandle handle, Object newValue) {
        ((AbstractRuleSessionOps)this.rule.getRuntime()).bufferUpdate(false, (DefaultFactHandle)handle, newValue, this.destinationForRuleActions);
    }

    @Override
    public final RhsContext update(Object obj) {
        CachedFactEntry entry = this.findByFact(Objects.requireNonNull(obj, "Facts not allowed to be null"));
        if (entry == null) {
            LOGGER.warning(() -> "Rule '" + this.rule.getName() + "'. Fact " + String.valueOf(obj) + " is not known to the context. This operation is only possible for facts previously retrieved via a get(...) method. The UPDATE operation skipped.");
        } else {
            ((AbstractRuleSessionOps)this.rule.getRuntime()).bufferUpdate(false, entry.handle, obj, this.destinationForRuleActions);
        }
        return this;
    }

    @Override
    public final RhsContext delete(Object obj) {
        Objects.requireNonNull(obj, "Facts not allowed to be null");
        if (obj instanceof FactHandle) {
            this.delete((FactHandle)obj);
        } else {
            this.deleteCurrentFact(obj);
        }
        return this;
    }

    private void deleteCurrentFact(Object obj) {
        CachedFactEntry entry = this.findByFact(obj);
        if (entry == null) {
            LOGGER.warning(() -> "Rule '" + this.rule.getName() + "'. Fact " + String.valueOf(obj) + " is not known to the context. This operation is only possible for facts previously retrieved via a get(...) method. The DELETE operation skipped.");
        } else {
            ((AbstractRuleSessionOps)this.rule.getRuntime()).bufferDelete(entry.handle, false, entry.wrapper, this.destinationForRuleActions);
        }
    }

    @Override
    public RuntimeRule getRule() {
        return this.rule;
    }

    @Override
    public Object getObject(String name) {
        return this.currentFactByFactName(name);
    }

    private static class CachedFactEntry {
        final FactHolder wrapper;
        final DefaultFactHandle handle;

        CachedFactEntry(FactHolder wrapper, DefaultFactHandle handle) {
            this.wrapper = wrapper;
            this.handle = handle;
        }
    }
}

