/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.evrete.api.LhsField;
import org.evrete.runtime.AbstractLhsFact;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.FactType;
import org.evrete.runtime.LhsConditionDH;
import org.evrete.runtime.MapOfSet;
import org.evrete.runtime.Mask;
import org.evrete.runtime.evaluation.BetaEvaluator;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;
import org.evrete.util.MapFunction;

class RuleBuilderActiveConditions {
    private final Collection<LhsConditionDH<String, ActiveField>> allBetaConditions = new LinkedList<LhsConditionDH<String, ActiveField>>();
    private final MapOfSet<String, DefaultEvaluatorHandle> alphaConditionsByFactName = new MapOfSet();

    RuleBuilderActiveConditions() {
    }

    void add(LhsConditionDH<String, ActiveField> condition) {
        LhsField.Array descriptor = condition.getDescriptor();
        if (descriptor.length() == 0) {
            throw new IllegalStateException("Empty condition descriptor");
        }
        if (descriptor.length() == 1) {
            String factVarName = (String)descriptor.get(0).fact();
            this.alphaConditionsByFactName.add(factVarName, (DefaultEvaluatorHandle)condition.getCondition());
        } else {
            this.allBetaConditions.add(condition);
        }
    }

    Set<DefaultEvaluatorHandle> getAlphaConditionsOf(String factName) {
        return this.alphaConditionsByFactName.getOrDefault(factName, (DefaultEvaluatorHandle)((Object)Collections.emptySet()));
    }

    Collection<BetaEvaluator> flattenBetaConditions(Collection<FactType> ruleFactTypes) {
        Mask mask;
        if (this.allBetaConditions.isEmpty()) {
            return Collections.emptyList();
        }
        MapFunction<String, FactType> nameToIndexMapping = new MapFunction<String, FactType>(ruleFactTypes, AbstractLhsFact::getVarName);
        MapOfSet grouping = new MapOfSet();
        for (LhsConditionDH<String, ActiveField> condition : this.allBetaConditions) {
            LhsField.Array descriptor = condition.getDescriptor().transform(lhsField -> {
                FactType referencedType = (FactType)nameToIndexMapping.apply((String)lhsField.fact());
                return new LhsField(referencedType, lhsField);
            });
            mask = Mask.factTypeMask();
            for (int i = 0; i < descriptor.length(); ++i) {
                mask.set((FactType)descriptor.get(i).fact());
            }
            grouping.add(mask, new LhsConditionDH(condition, descriptor));
        }
        ArrayList<BetaEvaluator> result = new ArrayList<BetaEvaluator>(this.allBetaConditions.size());
        for (Map.Entry entry : grouping.entrySet()) {
            mask = (Mask)entry.getKey();
            result.add(new BetaEvaluator(mask, (Set)entry.getValue()));
        }
        return result;
    }
}

