/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.evrete.api.Named;

public class SearchList<T extends Named>
implements Iterable<T> {
    private final List<T> list = new ArrayList<T>();
    private final Map<String, T> map = new HashMap<String, T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) {
        List<T> list = this.list;
        synchronized (list) {
            this.list.add(t);
            this.map.put(t.getName(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllAndSort(Collection<T> collection, Comparator<? super T> comparator) {
        List<T> list = this.list;
        synchronized (list) {
            for (Named t : collection) {
                this.list.add(t);
                this.map.put(t.getName(), t);
            }
            this.list.sort(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<? super T> comparator) {
        List<T> list = this.list;
        synchronized (list) {
            this.list.sort(comparator);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public List<T> getList() {
        return this.list;
    }

    public Stream<T> stream() {
        return this.list.stream();
    }

    public T get(String name) {
        return (T)((Named)this.map.get(name));
    }
}

