/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.AbstractRuleSessionBase;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeFactGroup;
import org.evrete.runtime.SessionFactGroupBeta;
import org.evrete.runtime.SessionFactGroupPlain;
import org.evrete.runtime.SessionFactType;
import org.evrete.runtime.SessionMemory;

abstract class SessionFactGroup
extends KnowledgeFactGroup {
    protected final Executor executor;
    protected final SessionFactType[] factTypes;

    protected SessionFactGroup(AbstractRuleSessionBase<?> runtime, KnowledgeFactGroup knowledgeFactGroup) {
        super(knowledgeFactGroup);
        this.executor = runtime.getService().getExecutor();
        FactType[] entryNodes = this.getEntryNodes();
        SessionMemory memory = runtime.getMemory();
        this.factTypes = new SessionFactType[entryNodes.length];
        for (int i = 0; i < entryNodes.length; ++i) {
            SessionFactType sessionFactType;
            this.factTypes[i] = sessionFactType = new SessionFactType(entryNodes[i], memory);
        }
    }

    SessionFactType[] getFactTypes() {
        return this.factTypes;
    }

    abstract void clearMemories();

    abstract CompletableFuture<Void> processDeleteDeltaActions(Collection<FactHolder> var1);

    protected abstract boolean isPlain();

    abstract Iterator<DefaultFactHandle[]> factHandles(MemoryScope var1);

    abstract CompletableFuture<Void> commitDeltas();

    abstract CompletableFuture<Void> buildDeltas(DeltaMemoryMode var1);

    public static SessionFactGroup factory(AbstractRuleSessionBase<?> runtime, KnowledgeFactGroup knowledgeFactGroup) {
        if (knowledgeFactGroup instanceof KnowledgeFactGroup.Plain) {
            return new SessionFactGroupPlain(runtime, (KnowledgeFactGroup.Plain)knowledgeFactGroup);
        }
        if (knowledgeFactGroup instanceof KnowledgeFactGroup.Beta) {
            return new SessionFactGroupBeta(runtime, (KnowledgeFactGroup.Beta)knowledgeFactGroup);
        }
        throw new IllegalArgumentException("Unknown ReteFactGroup type: " + String.valueOf(knowledgeFactGroup));
    }

    public String toString() {
        return "{plain=" + this.isPlain() + "facts= " + FactType.toSimpleDebugString((FactType[])this.factTypes) + "}";
    }
}

