/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.AbstractRuleSessionBase;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.FactHolder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeFactGroup;
import org.evrete.runtime.SessionFactGroup;
import org.evrete.runtime.rete.ConditionMemory;
import org.evrete.runtime.rete.ReteGraph;
import org.evrete.runtime.rete.ReteKnowledgeConditionNode;
import org.evrete.runtime.rete.ReteKnowledgeEntryNode;
import org.evrete.runtime.rete.ReteSessionConditionNode;
import org.evrete.runtime.rete.ReteSessionEntryNode;
import org.evrete.runtime.rete.ReteSessionNode;
import org.evrete.util.CombinationIterator;
import org.evrete.util.CommonUtils;
import org.evrete.util.FlatMapIterator;

class SessionFactGroupBeta
extends SessionFactGroup {
    private static final Logger LOGGER = Logger.getLogger(SessionFactGroupBeta.class.getName());
    private final ReteGraph<ReteSessionNode, ReteSessionEntryNode, ReteSessionConditionNode> graph;
    private final DefaultFactHandle[] currentFactHandles;

    SessionFactGroupBeta(AbstractRuleSessionBase<?> runtime, KnowledgeFactGroup.Beta factGroup) {
        super(runtime, factGroup);
        int totalFactTypes = this.getEntryNodes().length;
        this.currentFactHandles = new DefaultFactHandle[totalFactTypes];
        this.graph = factGroup.getGraph().transform(ReteSessionNode.class, (conditionNode, sources) -> new ReteSessionConditionNode(runtime, (ReteSessionNode[])sources, (ReteKnowledgeConditionNode)conditionNode), entryNode -> new ReteSessionEntryNode(runtime, (ReteKnowledgeEntryNode)entryNode));
    }

    @Override
    protected boolean isPlain() {
        return false;
    }

    @Override
    CompletableFuture<Void> processDeleteDeltaActions(Collection<FactHolder> factHolders) {
        LinkedList conditionNodes = new LinkedList();
        this.graph.forEachConditionNode(conditionNodes::add);
        return CommonUtils.completeAll(conditionNodes, node -> CompletableFuture.runAsync(() -> node.deleteAll(factHolders), this.executor));
    }

    @Override
    void clearMemories() {
        this.graph.forEachConditionNode(ReteSessionConditionNode::clearMemories);
    }

    public ReteGraph<ReteSessionNode, ReteSessionEntryNode, ReteSessionConditionNode> getGraph() {
        return this.graph;
    }

    @Override
    CompletableFuture<Void> buildDeltas(DeltaMemoryMode mode) {
        LOGGER.fine(() -> "Starting to build delta memory for group " + FactType.toSimpleDebugString((FactType[])this.factTypes) + " in mode: " + String.valueOf((Object)mode));
        return this.graph.terminalNode().computeDeltaMemoryAsync(mode);
    }

    @Override
    public CompletableFuture<Void> commitDeltas() {
        LinkedList futures = new LinkedList();
        this.graph.forEachConditionNode(node -> futures.add(CompletableFuture.runAsync(node::commit, this.executor)));
        return CommonUtils.completeAll(futures);
    }

    @Override
    Iterator<DefaultFactHandle[]> factHandles(MemoryScope scope) {
        return new FlatMapIterator(this.graph.terminalNode().memoryIterator(scope), this::combinations);
    }

    private Iterator<DefaultFactHandle[]> combinations(ConditionMemory.ScopedValueId[] keys) {
        return new CombinationIterator<DefaultFactHandle>(this.currentFactHandles, index -> this.factTypes[index].factIterator(keys[index]));
    }
}

