/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.evrete.api.RhsContext;
import org.evrete.api.RuntimeRule;
import org.evrete.api.spi.MemoryScope;
import org.evrete.runtime.AbstractActiveRule;
import org.evrete.runtime.AbstractRuleSessionOps;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.KnowledgeLhs;
import org.evrete.runtime.KnowledgeRule;
import org.evrete.runtime.RhsContextImpl;
import org.evrete.runtime.SessionFactGroup;
import org.evrete.runtime.SessionLhs;
import org.evrete.runtime.WorkMemoryActionBuffer;
import org.evrete.util.CombinationIterator;
import org.evrete.util.MapFunction;

public class SessionRule
extends AbstractActiveRule<SessionFactGroup, SessionLhs, AbstractRuleSessionOps<?>>
implements RuntimeRule {
    private static final Logger LOGGER = Logger.getLogger(SessionRule.class.getName());
    private final DefaultFactHandle[][] currentGroupedFacts;
    private final MapFunction<String, KnowledgeLhs.FactPosition> factPositionMapping;

    SessionRule(KnowledgeRule knowledgeRule, AbstractRuleSessionOps<?> sessionRuntime) {
        super(sessionRuntime, knowledgeRule, SessionLhs.factory(sessionRuntime, (KnowledgeLhs)knowledgeRule.getLhs()));
        SessionFactGroup[] factGroups = (SessionFactGroup[])((SessionLhs)this.getLhs()).getFactGroups();
        this.currentGroupedFacts = new DefaultFactHandle[factGroups.length][];
        this.factPositionMapping = ((KnowledgeLhs)knowledgeRule.getLhs()).getFactPositionMapping();
        LOGGER.fine(() -> "Session rule created: " + String.valueOf(this));
    }

    final long callRhs(WorkMemoryActionBuffer destinationForRuleActions) {
        LOGGER.fine(() -> "RHS START for rule '" + this.getName() + "'");
        Consumer<RhsContext> ruleRhs = this.getRhs();
        RhsContextImpl rhsContext = new RhsContextImpl(this, this.currentGroupedFacts, this.factPositionMapping, (SessionFactGroup[])((SessionLhs)this.getLhs()).getFactGroups(), destinationForRuleActions);
        SessionFactGroup[] groups = (SessionFactGroup[])((SessionLhs)this.getLhs()).getFactGroups();
        Iterator<MemoryScope[]> scopesIterator = MemoryScope.states(MemoryScope.DELTA, new MemoryScope[groups.length]);
        scopesIterator.forEachRemaining(scopes -> this.callRhs(groups, (MemoryScope[])scopes, ruleRhs, rhsContext));
        LOGGER.fine(() -> "RHS END for rule '" + this.getName() + "'");
        return rhsContext.activationCount.get();
    }

    private void callRhs(SessionFactGroup[] groups, MemoryScope[] scopes, Consumer<RhsContext> ruleRhs, RhsContextImpl rhsContext) {
        LOGGER.fine(() -> "RHS memory scopes for groups: " + Arrays.toString((Object[])scopes));
        CombinationIterator joinedFacts = new CombinationIterator((T[])this.currentGroupedFacts, index -> groups[index].factHandles(scopes[index]));
        joinedFacts.forEachRemaining(ignored -> ruleRhs.accept(rhsContext.next()));
    }

    MapFunction<String, KnowledgeLhs.FactPosition> getFactPositionMapping() {
        return this.factPositionMapping;
    }

    public String toString() {
        return "{name='" + this.getName() + "', lhs=" + String.valueOf(this.getLhs()) + "}";
    }

    public void clear() {
        for (SessionFactGroup group : (SessionFactGroup[])((SessionLhs)this.getLhs()).getFactGroups()) {
            group.clearMemories();
        }
    }

    @Override
    public RuntimeRule set(String property, Object value) {
        super.set(property, value);
        return this;
    }
}

