/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Map;
import java.util.stream.Stream;
import org.evrete.api.FactHandle;
import org.evrete.api.spi.FactStorage;
import org.evrete.api.spi.ValueIndexer;
import org.evrete.runtime.AbstractRuleSession;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.FactFieldValues;
import org.evrete.runtime.FactHolder;
import org.evrete.util.FactStorageWrapper;
import org.evrete.util.MapEntryImpl;

public final class TypeMemory
extends FactStorageWrapper<DefaultFactHandle, FactHolder> {
    private final int fieldCount;
    private final String logicalType;
    private final Class<?> javaType;
    private final ValueIndexer<FactFieldValues> fieldValuesIndexer;
    private final ActiveType type;

    TypeMemory(ActiveType type, FactStorage<DefaultFactHandle, FactHolder> factStorage, ValueIndexer<FactFieldValues> fieldValuesIndexer) {
        super(factStorage);
        this.type = type;
        this.fieldCount = type.getFieldCount();
        this.logicalType = type.getValue().getName();
        this.javaType = type.getValue().getJavaClass();
        this.fieldValuesIndexer = fieldValuesIndexer;
    }

    public ActiveType getType() {
        return this.type;
    }

    TypeMemory(AbstractRuleSession<?> runtime, ActiveType type) {
        this(type, runtime.newTypeFactStorage(), runtime.newFieldValuesIndexer());
    }

    ValueIndexer<FactFieldValues> getFieldValuesIndexer() {
        return this.fieldValuesIndexer;
    }

    public FactFieldValues readFieldValues(long valueId) {
        return this.fieldValuesIndexer.get(valueId);
    }

    public String getLogicalType() {
        return this.logicalType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public <T> Stream<Map.Entry<FactHandle, T>> streamFactEntries() {
        return this.stream().map(entry -> new MapEntryImpl<FactHandle, Object>((FactHandle)entry.getKey(), ((FactHolder)entry.getValue()).getFact()));
    }

    public void insert(FactHolder value) {
        this.insert(value.getHandle(), value);
    }
}

