/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.evrete.collections.LongKeyMap;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.DeltaMemoryAction;

class WorkMemoryActionBuffer {
    static final WorkMemoryActionBuffer EMPTY = new WorkMemoryActionBuffer();
    private final LongKeyMap<State> actionsPerFactHandle;

    private WorkMemoryActionBuffer(LongKeyMap<State> actionsPerFactHandle) {
        this.actionsPerFactHandle = actionsPerFactHandle;
    }

    public WorkMemoryActionBuffer() {
        this(new LongKeyMap<State>());
    }

    void clear() {
        this.actionsPerFactHandle.clear();
    }

    void addInsert(DeltaMemoryAction.Insert insertOp) {
        this.actionsPerFactHandle.computeIfAbsent(insertOp.getHandle().getId(), () -> new State(insertOp.getType())).applyInsert(insertOp);
    }

    void addDelete(DeltaMemoryAction.Delete deleteOp) {
        this.actionsPerFactHandle.computeIfAbsent(deleteOp.getHandle().getId(), () -> new State(deleteOp.getType())).applyDelete(deleteOp);
    }

    CompletableFuture<Collection<SplitView>> sinkToSplitView(ExecutorService executor) {
        return CompletableFuture.supplyAsync(this::sinkToSplitViewSync, executor);
    }

    private Collection<SplitView> sinkToSplitViewSync() {
        HashMap map = new HashMap();
        this.actionsPerFactHandle.forEach(state -> {
            SplitView splitView = map.computeIfAbsent(state.type, SplitView::new);
            if (state.lastInsert != null) {
                splitView.add(state.lastInsert);
            }
            if (state.firstDelete != null) {
                splitView.add(state.firstDelete);
            }
        });
        this.clear();
        return map.values();
    }

    public boolean hasData() {
        return this.bufferedActionCount() > 0;
    }

    public int bufferedActionCount() {
        return this.actionsPerFactHandle.size();
    }

    static class State {
        DeltaMemoryAction.Insert lastInsert;
        DeltaMemoryAction.Delete firstDelete;
        final ActiveType type;

        State(ActiveType type) {
            this.type = type;
        }

        private void applyInsert(DeltaMemoryAction.Insert action) {
            this.lastInsert = Objects.requireNonNull(action);
        }

        private void applyDelete(DeltaMemoryAction.Delete action) {
            if (this.firstDelete == null) {
                this.firstDelete = Objects.requireNonNull(action);
            }
        }

        public String toString() {
            return "{lastInsert=" + String.valueOf(this.lastInsert) + ", firstDelete=" + String.valueOf(this.firstDelete) + "}";
        }
    }

    static class SplitView {
        private final ActiveType type;
        private final Collection<DeltaMemoryAction.Insert> inserts = new LinkedList<DeltaMemoryAction.Insert>();
        private final Collection<DeltaMemoryAction.Delete> deletes = new LinkedList<DeltaMemoryAction.Delete>();

        public SplitView(ActiveType type) {
            this.type = type;
        }

        public ActiveType getType() {
            return this.type;
        }

        void add(DeltaMemoryAction.Insert action) {
            this.inserts.add(action);
        }

        void add(DeltaMemoryAction.Delete action) {
            this.deletes.add(action);
        }

        public Collection<DeltaMemoryAction.Insert> getInserts() {
            return this.inserts;
        }

        public Collection<DeltaMemoryAction.Delete> getDeletes() {
            return this.deletes;
        }
    }
}

