/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.compiler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evrete.api.LhsField;
import org.evrete.runtime.compiler.StringLiteralEncoder;

class ConditionStringTerm {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\$[a-zA-Z0-9]+(\\.[_a-zA-Z][_a-zA-Z0-9]*)*");
    final int start;
    final int end;
    final String varName;
    final LhsField<String, String> ref;

    ConditionStringTerm(int start, int end, LhsField<String, String> ref, AtomicInteger fieldCounter) {
        this.start = start;
        this.end = end;
        this.varName = "var" + fieldCounter.incrementAndGet();
        this.ref = ref;
    }

    ConditionStringTerm(int start, int end, ConditionStringTerm existing) {
        this.start = start;
        this.end = end;
        this.varName = existing.varName;
        this.ref = existing.ref;
    }

    private static ConditionStringTerm resolveTerm(int start, int end, LhsField<String, String> ref, AtomicInteger fieldCounter, List<ConditionStringTerm> terms) {
        for (ConditionStringTerm t : terms) {
            if (!t.ref.equals(ref)) continue;
            return new ConditionStringTerm(start, end, t);
        }
        return new ConditionStringTerm(start, end, ref, fieldCounter);
    }

    static List<ConditionStringTerm> resolveTerms(StringLiteralEncoder.Encoded encoded) {
        String expression = encoded.value;
        Matcher m = REFERENCE_PATTERN.matcher(expression);
        ArrayList<ConditionStringTerm> terms = new ArrayList<ConditionStringTerm>();
        AtomicInteger fieldCounter = new AtomicInteger();
        while (m.find()) {
            int end;
            int start = m.start();
            int actualEnd = end = m.end();
            if (end < expression.length() && expression.charAt(end) == '(') {
                actualEnd = expression.substring(start, end).lastIndexOf(46) + start;
            }
            String matched = expression.substring(start, actualEnd);
            LhsField<String, String> fieldReference = LhsField.parseDottedVariable(matched);
            ConditionStringTerm t = ConditionStringTerm.resolveTerm(start, actualEnd, fieldReference, fieldCounter, terms);
            terms.add(t);
        }
        return terms;
    }

    public String toString() {
        return "ConditionStringTerm{start=" + this.start + ", end=" + this.end + ", varName='" + this.varName + "'}";
    }
}

