/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime.rete;

import java.util.ArrayList;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.FactType;
import org.evrete.runtime.MapOfList;
import org.evrete.runtime.rete.ReteNode;

public abstract class ReteKnowledgeNode
extends ReteNode<ReteKnowledgeNode> {
    public static final ReteKnowledgeNode[] EMPTY_ARRAY = new ReteKnowledgeNode[0];
    private final FactType[] nodeFactTypes;
    private final MapOfList<ActiveType.Idx, Integer> typeToIndices;
    private final int[][] nodeFactTypesMapping;

    protected ReteKnowledgeNode(FactType factType) {
        super((ReteNode[])EMPTY_ARRAY);
        this.nodeFactTypes = new FactType[]{factType};
        this.nodeFactTypesMapping = new int[0][];
        this.typeToIndices = new MapOfList();
        this.typeToIndices.add(factType.typeId(), 0);
    }

    protected ReteKnowledgeNode(ReteKnowledgeNode[] sourceNodes) {
        super((ReteNode[])sourceNodes);
        ArrayList<FactType> nodeFactTypes = new ArrayList<FactType>();
        this.nodeFactTypesMapping = new int[sourceNodes.length][];
        int nodeFactTypesIndex = 0;
        this.typeToIndices = new MapOfList();
        for (int sourceIndex = 0; sourceIndex < sourceNodes.length; ++sourceIndex) {
            ReteKnowledgeNode sourceNode = sourceNodes[sourceIndex];
            FactType[] sourceNodeFactTypes = sourceNode.getNodeFactTypes();
            this.nodeFactTypesMapping[sourceIndex] = new int[sourceNodeFactTypes.length];
            for (int j = 0; j < sourceNodeFactTypes.length; ++j) {
                FactType sourceFactType = sourceNodeFactTypes[j];
                nodeFactTypes.add(sourceFactType);
                this.nodeFactTypesMapping[sourceIndex][j] = nodeFactTypesIndex;
                this.typeToIndices.add(sourceFactType.typeId(), nodeFactTypesIndex);
                ++nodeFactTypesIndex;
            }
        }
        this.nodeFactTypes = nodeFactTypes.toArray(FactType.EMPTY_ARRAY);
    }

    public MapOfList<ActiveType.Idx, Integer> getTypeToIndices() {
        return this.typeToIndices;
    }

    public int[][] getNodeFactTypesMapping() {
        return this.nodeFactTypesMapping;
    }

    public FactType[] getNodeFactTypes() {
        return this.nodeFactTypes;
    }
}

