/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal;

import java.util.Map;
import java.util.stream.Stream;
import org.evrete.api.FactHandle;
import org.evrete.api.spi.FactStorage;
import org.evrete.collections.LongKeyMap;
import org.evrete.util.MapEntryImpl;

public class DefaultFactStorage<FH extends FactHandle, V>
implements FactStorage<FH, V> {
    private final Storage<FH, V> delegate = new Storage();

    @Override
    public void insert(FH factHandle, V value) {
        this.delegate.insert(factHandle, value);
    }

    @Override
    public V remove(FH factHandle) {
        return this.delegate.remove(factHandle);
    }

    @Override
    public V get(FH factHandle) {
        return this.delegate.get(factHandle);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Stream<Map.Entry<FH, V>> stream() {
        return this.delegate.storage.values().map(fhvMapEntry -> fhvMapEntry);
    }

    private static class Storage<FH extends FactHandle, V> {
        private final LongKeyMap<MapEntryImpl<FH, V>> storage = new LongKeyMap();

        private Storage() {
        }

        synchronized void insert(FH factHandle, V value) {
            this.storage.put(factHandle.getId(), new MapEntryImpl<FH, V>(factHandle, value));
        }

        synchronized V remove(FH factHandle) {
            MapEntryImpl<FH, V> found = this.storage.remove(factHandle.getId());
            return found == null ? null : (V)found.getValue();
        }

        V get(FH factHandle) {
            MapEntryImpl<FH, V> found = this.storage.get(factHandle.getId());
            return found == null ? null : (V)found.getValue();
        }

        synchronized void clear() {
            this.storage.clear();
        }
    }
}

