/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal.compiler;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.evrete.spi.minimal.compiler.AbstractJavaObject;
import org.evrete.spi.minimal.compiler.ClassLoaderWrapper;
import org.evrete.spi.minimal.compiler.DestinationClassObject;
import org.evrete.spi.minimal.compiler.PackageExplorer;

final class InMemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final ClassLoaderWrapper classLoader;
    private final PackageExplorer finder;
    private final Collection<DestinationClassObject> output = new LinkedList<DestinationClassObject>();

    InMemoryFileManager(JavaFileManager fileManager, ClassLoaderWrapper classLoader) {
        super(fileManager);
        this.classLoader = classLoader;
        this.finder = new PackageExplorer(classLoader);
    }

    Collection<DestinationClassObject> getOutput() {
        return this.output;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
        DestinationClassObject compiled = new DestinationClassObject(className);
        this.output.add(compiled);
        return compiled;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return super.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> defaultFiles = super.list(location, packageName, kinds, recurse);
        if (location != StandardLocation.CLASS_PATH || packageName.startsWith("java.") || packageName.equals("java")) {
            return defaultFiles;
        }
        LinkedList<JavaFileObject> result = new LinkedList<JavaFileObject>();
        defaultFiles.iterator().forEachRemaining(result::add);
        result.addAll(this.classLoader.getDefinedClasses(packageName));
        result.addAll(this.finder.find(packageName));
        return result;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof AbstractJavaObject) {
            return ((AbstractJavaObject)file).getBinaryName();
        }
        return super.inferBinaryName(location, file);
    }
}

