/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.spi.minimal.compiler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicLong;
import javax.tools.JavaFileObject;
import org.evrete.api.spi.SourceCompiler;
import org.evrete.spi.minimal.compiler.AbstractJavaObject;
import org.evrete.spi.minimal.compiler.ClassMeta;

class JavaSourceObject
extends AbstractJavaObject {
    private static final AtomicLong SOURCE_COUNTER = new AtomicLong();
    private final String simpleName;
    private final SourceCompiler.ClassSource source;
    private final URI uri;

    JavaSourceObject(SourceCompiler.ClassSource source) {
        ClassMeta meta = new ClassMeta(source.binaryName());
        this.simpleName = meta.getSimpleName();
        this.source = source;
        this.uri = URI.create("string:///source-" + SOURCE_COUNTER.incrementAndGet() + "." + JavaFileObject.Kind.SOURCE.extension);
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return kind == JavaFileObject.Kind.SOURCE && this.simpleName.equals(simpleName);
    }

    SourceCompiler.ClassSource getSource() {
        return this.source;
    }

    @Override
    public Writer openWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.source.getSource().getBytes());
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    public URI toUri() {
        return this.uri;
    }

    @Override
    public OutputStream openOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.source.getSource();
    }

    @Override
    String getBinaryName() {
        return this.source.binaryName();
    }

    public String toString() {
        String sep = System.lineSeparator();
        StringBuilder sb = new StringBuilder(this.source.getSource().length() * 2);
        sb.append(sep).append('\'').append(this.getBinaryName()).append("':").append(sep);
        Scanner scanner = new Scanner(this.source.getSource());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            sb.append("\t").append(line).append(sep);
        }
        return sb.toString();
    }
}

