/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.evrete.api.LhsField;
import org.evrete.api.NamedType;
import org.evrete.api.Type;
import org.evrete.api.TypeField;

public final class CommonUtils {
    private static final CompletableFuture<?>[] EMPTY_FUTURES = new CompletableFuture[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> T[] array(Class<T> type, int size) {
        return (Object[])Array.newInstance(type, size);
    }

    public static <T> Set<T> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    public static <K, V> V[] mapArray(Class<V> type, K[] arr, Function<K, V> mapper) {
        V[] result = CommonUtils.array(type, arr.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = mapper.apply(arr[i]);
        }
        return result;
    }

    public static String[] splitConfigString(String arg) {
        return CommonUtils.splitConfigString(arg, "[\\s+,;]");
    }

    public static String[] splitCSV(String arg) {
        return CommonUtils.splitConfigString(arg, "[,]");
    }

    private static String[] splitConfigString(String arg, String pattern) {
        if (arg == null || arg.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] parts = arg.trim().split(pattern);
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String part : parts) {
            String trimmed = part.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    public static Optional<Collection<?>> resolveCollection(Object o) {
        if (o.getClass().isArray()) {
            return Optional.of(Arrays.asList((Object[])o));
        }
        if (o instanceof Iterable) {
            LinkedList ret = new LinkedList();
            ((Iterable)o).forEach(ret::add);
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public static Collection<?> toCollection(Object o) {
        return CommonUtils.resolveCollection(o).orElse(Collections.singleton(o));
    }

    public static byte[] toByteArray(InputStream is) {
        try {
            return CommonUtils.toByteArrayChecked(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toString(Reader reader) throws IOException {
        int numRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numRead);
        }
        return buffer.toString();
    }

    public static byte[] toByteArrayChecked(InputStream is) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[8192];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                bos.write(data, 0, nRead);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static byte[] bytes(JarFile jarFile, ZipEntry entry) {
        try {
            return CommonUtils.toByteArray(jarFile.getInputStream(entry));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <V> CompletableFuture<List<V>> completeAndCollect(List<CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<Void> completedFactInserts = CompletableFuture.allOf(futures.toArray(EMPTY_FUTURES));
        return completedFactInserts.thenApply(unused -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <V, T> CompletableFuture<List<V>> completeAndCollect(Collection<T> list, Function<T, CompletableFuture<V>> mapper) {
        if (list.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList<CompletableFuture<V>> futureList = new ArrayList<CompletableFuture<V>>(list.size());
        for (T v : list) {
            futureList.add(mapper.apply(v));
        }
        return CommonUtils.completeAndCollect(futureList);
    }

    public static <T> CompletableFuture<Void> completeAll(Collection<CompletableFuture<T>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf(futures.toArray(EMPTY_FUTURES));
    }

    public static <T, F> CompletableFuture<Void> completeAll(T[] arr, Function<T, CompletableFuture<F>> futureFunction) {
        return CommonUtils.completeAll(Arrays.asList(arr), futureFunction);
    }

    public static <T, F> CompletableFuture<Void> completeAll(Collection<T> collection, Function<T, CompletableFuture<F>> futureFunction) {
        if (collection.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ArrayList<CompletableFuture<T>> futuresList = new ArrayList<CompletableFuture<T>>();
        for (T t : collection) {
            futuresList.add(futureFunction.apply(t));
        }
        return CommonUtils.completeAll(futuresList);
    }

    public static LhsField<String, TypeField> toTypeField(LhsField<String, String> lhsField, NamedType.Resolver namedTypeResolver) {
        String factName = lhsField.fact();
        Type<?> type = namedTypeResolver.resolve(factName).getType();
        String rawFieldName = lhsField.field();
        if (rawFieldName == null) {
            rawFieldName = "";
        }
        TypeField typeField = type.getField(rawFieldName);
        return new LhsField<String, TypeField>(factName, typeField);
    }
}

