/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class DelegatingExecutorService
implements ExecutorService {
    private static final Logger LOGGER = Logger.getLogger(DelegatingExecutorService.class.getName());
    private final ExecutorService delegate;
    private final boolean externallySupplied;

    public DelegatingExecutorService(ExecutorService delegate) {
        this.delegate = delegate;
        this.externallySupplied = true;
    }

    public DelegatingExecutorService(int threads, boolean daemonThreads) {
        this.delegate = Executors.newFixedThreadPool(threads, new CustomThreadFactory(daemonThreads));
        this.externallySupplied = false;
    }

    @Override
    public void shutdown() {
        if (!this.externallySupplied) {
            try {
                this.delegate.shutdown();
            }
            catch (Exception e) {
                LOGGER.warning("Failed to shut down executor service: " + e.getMessage());
            }
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.externallySupplied) {
            LOGGER.info("ShutdownNow should be manually called on externally supplied ExecutorService.");
            return List.of();
        }
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    static class CustomThreadFactory
    implements ThreadFactory {
        private static final String PREFIX = "evrete-thread";
        private final AtomicInteger threadCount = new AtomicInteger(0);
        private final ThreadGroup group = new ThreadGroup("evrete-thread-group");
        private final boolean daemonThreads;

        CustomThreadFactory(boolean daemonThreads) {
            this.daemonThreads = daemonThreads;
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = String.format("%s-%d", PREFIX, this.threadCount.getAndIncrement());
            Thread thread = new Thread(this.group, r, threadName, 0L);
            thread.setDaemon(this.daemonThreads);
            thread.setPriority(5);
            return thread;
        }
    }
}

