/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ForkingMap<K, V> {
    private final Map<K, V> map = new HashMap();
    private final ForkingMap<K, V> parent;

    public ForkingMap() {
        this(null);
    }

    private ForkingMap(ForkingMap<K, V> parent) {
        this.parent = parent;
    }

    public ForkingMap<K, V> nextBranch() {
        return new ForkingMap<K, V>(this);
    }

    public V get(K key) {
        V found = this.map.get(key);
        if (found == null) {
            return this.parent == null ? null : (V)this.parent.get(key);
        }
        return found;
    }

    public void replace(K key, V value) {
        K k = Objects.requireNonNull(key);
        V v = Objects.requireNonNull(value);
        V found = this.map.get(k);
        if (found == null) {
            if (this.parent != null) {
                this.parent.replace(k, v);
            }
        } else {
            this.map.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.map.put(key, value);
        }
    }
}

