/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Objects;
import org.evrete.api.spi.SourceCompiler;

public final class JavaSourceUtils {
    public static SourceCompiler.ClassSource parse(String source) {
        String src = JavaSourceUtils.removeBlockComments(Objects.requireNonNull(source));
        String[] lines = src.replaceAll("\n\r", "\n").replaceAll("\r\n", "\n").replaceAll("\r", "\n").split("\n");
        StringBuilder sb = new StringBuilder(source.length());
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.isEmpty() || trimmed.startsWith("//")) continue;
            sb.append(trimmed).append('\n');
        }
        src = sb.toString().trim();
        int p = source.indexOf(123);
        if (p < 0) {
            throw new IllegalArgumentException("Not a Java source");
        }
        if ((p = (src = src.substring(0, p - 1).trim()).indexOf("package")) < 0) {
            throw new IllegalArgumentException("Unnamed (default) packages are not supported");
        }
        int semi = source.indexOf(59);
        if (semi < 0) {
            throw new IllegalArgumentException("Not a Java source");
        }
        String packageName = source.substring(p + "package".length() + 1, semi).trim();
        String[] parts = src.replaceAll("\\n", "").split(";");
        String classDef = parts[parts.length - 1];
        String[] words = classDef.split("\\s+");
        for (int i = 0; i < words.length - 1; ++i) {
            String w = words[i];
            if (!JavaSourceUtils.isClassDef(w)) continue;
            String simpleName = words[i + 1].trim();
            String binaryName = packageName + "." + simpleName;
            return new SourceImpl(source, binaryName);
        }
        throw new IllegalArgumentException("Couldn't find any of the class|interface|enum|record keywords");
    }

    private static boolean isClassDef(String s) {
        return "class".equals(s) || "enum".equals(s) || "record".equals(s) || "interface".equals(s);
    }

    static String removeBlockComments(String arg) {
        int open = arg.indexOf("/*");
        if (open < 0) {
            return arg;
        }
        int close = arg.indexOf("*/", open + 2);
        if (close < 0) {
            throw new IllegalArgumentException("Malformed block comment in '" + arg + "'");
        }
        String blockRemoved = arg.substring(0, open) + arg.substring(close + 2);
        return JavaSourceUtils.removeBlockComments(blockRemoved);
    }

    private static class SourceImpl
    implements SourceCompiler.ClassSource {
        private final String source;
        private final String binaryName;

        public SourceImpl(String source, String binaryName) {
            this.source = source;
            this.binaryName = binaryName;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public String binaryName() {
            return this.binaryName;
        }
    }
}

