/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class MapFunction<K, V>
implements Function<K, V> {
    private final Map<K, V> map = new HashMap();

    public MapFunction() {
    }

    public MapFunction(Collection<V> collection, Function<V, K> keyMapper) {
        this();
        for (V v : collection) {
            this.putNew(keyMapper.apply(v), v);
        }
    }

    public void putNew(K key, V value) {
        if (this.map.put(key, value) != null) {
            throw new IllegalStateException("Key " + String.valueOf(key) + " is already associated with a value.");
        }
    }

    public int size() {
        return this.map.size();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public V apply(K k) {
        V found = this.map.get(k);
        if (found == null) {
            throw new IllegalArgumentException("No object can be found for key " + String.valueOf(k));
        }
        return found;
    }
}

