/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.evrete.api.RuleSession;

public class SessionCollector<T, S extends RuleSession<S>>
implements Collector<T, S, S> {
    private static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH));
    private final S session;

    public SessionCollector(S session) {
        this.session = session;
    }

    @Override
    public Supplier<S> supplier() {
        return () -> this.session;
    }

    @Override
    public BiConsumer<S, T> accumulator() {
        return (acc, o) -> this.session.insert(o);
    }

    @Override
    public BinaryOperator<S> combiner() {
        return (acc1, acc2) -> this.session;
    }

    @Override
    public Function<S, S> finisher() {
        return a -> this.session;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return CHARACTERISTICS;
    }
}

