/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.collections;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.evrete.util.Indexed;

public class ArrayMap<K extends Indexed, V> {
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private Object[] data;

    public ArrayMap() {
        this.data = new Object[16];
    }

    public ArrayMap(int initialCapacity) {
        this.data = new Object[Math.max(initialCapacity, 16)];
    }

    public synchronized void put(K key, V value) {
        int idx = key.getIndex();
        this.put(idx, value);
    }

    private void put(int idx, V value) {
        if (idx >= this.data.length) {
            this.data = Arrays.copyOf(this.data, Math.max(idx * 2, 16));
        }
        this.data[idx] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        int idx = key.getIndex();
        V result = this.nullable(idx);
        if (result == null) {
            ArrayMap arrayMap = this;
            synchronized (arrayMap) {
                result = this.nullable(idx);
                if (result == null) {
                    result = mappingFunction.apply(key);
                    this.put(idx, result);
                }
            }
        }
        return result;
    }

    private V nullable(int idx) {
        if (idx >= this.data.length) {
            return null;
        }
        return (V)this.data[idx];
    }

    public V getChecked(K key) {
        return Objects.requireNonNull(this.get(key));
    }

    public V get(K key) {
        return this.nullable(key.getIndex());
    }

    public void clear() {
        Arrays.fill(this.data, null);
    }

    public Stream<V> values() {
        return Arrays.stream(this.data).filter(Objects::nonNull).map(o -> o);
    }

    public void forEach(Consumer<? super V> action) {
        for (Object o : this.data) {
            if (o == null) continue;
            action.accept(o);
        }
    }

    public String toString() {
        return Arrays.toString(this.data);
    }
}

