/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.concurrent.ExecutorService;
import org.evrete.api.events.ContextEvent;
import org.evrete.api.events.EventBus;
import org.evrete.api.events.Events;
import org.evrete.runtime.EventMessageBus;

public abstract class AbstractKnowledgeService
implements EventBus {
    private final EventMessageBus messageBus;
    private final ExecutorService executor;
    private final Events.Subscriptions serviceSubscriptions = new Events.Subscriptions();

    public AbstractKnowledgeService(ExecutorService executor) {
        this.messageBus = new EventMessageBus(executor);
        this.executor = executor;
    }

    protected EventMessageBus getMessageBus() {
        return this.messageBus;
    }

    public Events.Subscriptions getServiceSubscriptions() {
        return this.serviceSubscriptions;
    }

    @Override
    public <E extends ContextEvent> Events.Publisher<E> getPublisher(Class<E> eventClass) {
        return this.messageBus.getPublisher(eventClass);
    }

    protected void shutdownInner() {
        this.executor.shutdown();
        this.serviceSubscriptions.cancel();
    }

    public final ExecutorService getExecutor() {
        return this.executor;
    }
}

