/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.evrete.api.Rule;
import org.evrete.api.RuleSession;
import org.evrete.api.RuntimeRule;
import org.evrete.runtime.AbstractRuleSessionOps;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.DeltaMemoryMode;
import org.evrete.runtime.FactType;
import org.evrete.runtime.KnowledgeFactGroup;
import org.evrete.runtime.KnowledgeLhs;
import org.evrete.runtime.KnowledgeRule;
import org.evrete.runtime.KnowledgeRuntime;
import org.evrete.runtime.MapOfSet;
import org.evrete.runtime.RuntimeRules;
import org.evrete.runtime.SessionLhs;
import org.evrete.runtime.SessionRule;
import org.evrete.util.CommonUtils;

public abstract class AbstractRuleSessionDeployment<S extends RuleSession<S>>
extends AbstractRuleSessionOps<S> {
    final RuntimeRules ruleStorage = new RuntimeRules();

    AbstractRuleSessionDeployment(KnowledgeRuntime knowledge) {
        super(knowledge);
    }

    void deployRules(List<KnowledgeRule> descriptors, boolean hotDeployment) {
        CompletableFuture<Void> memoryAllocation = this.malloc(descriptors);
        CompletionStage convertedRules = memoryAllocation.thenCompose(v -> CommonUtils.completeAndCollect(descriptors, this::deploySingleRule));
        CompletionStage deployedRules = ((CompletableFuture)convertedRules).thenCompose(rules -> this.allocateBetaNodes((List<SessionRule>)rules, hotDeployment));
        CompletionStage finish = ((CompletableFuture)deployedRules).thenAccept(rules -> this.ruleStorage.addAllAndSort(rules, this.getRuleComparator()));
        ((CompletableFuture)finish).join();
    }

    private CompletableFuture<List<SessionRule>> allocateBetaNodes(List<SessionRule> sessionRules, boolean hotDeployment) {
        if (hotDeployment) {
            ArrayList betaUpdateTasks = new ArrayList(sessionRules.size());
            for (SessionRule r : sessionRules) {
                betaUpdateTasks.add(((SessionLhs)r.getLhs()).buildDeltas(DeltaMemoryMode.HOT_DEPLOYMENT));
            }
            return CommonUtils.completeAll(betaUpdateTasks).thenApply(ignored -> sessionRules);
        }
        return CompletableFuture.completedFuture(sessionRules);
    }

    private CompletableFuture<Void> malloc(Collection<KnowledgeRule> rules) {
        MapOfSet<ActiveType.Idx, AlphaAddress> alphaMemoriesByType = new MapOfSet<ActiveType.Idx, AlphaAddress>();
        for (KnowledgeRule rule : rules) {
            for (KnowledgeFactGroup group : ((KnowledgeLhs)rule.getLhs()).getFactGroups()) {
                for (FactType factType : group.getEntryNodes()) {
                    alphaMemoriesByType.add(factType.type().getId(), factType.getAlphaAddress());
                }
            }
        }
        return CommonUtils.completeAll(alphaMemoriesByType.entrySet(), entry -> this.getMemory().allocateMemoryIfNotExists((ActiveType.Idx)entry.getKey(), (Set)entry.getValue()));
    }

    private CompletableFuture<SessionRule> deploySingleRule(KnowledgeRule rule) {
        return CompletableFuture.supplyAsync(() -> new SessionRule(rule, this), this.getService().getExecutor());
    }

    private void reSortRules() {
        this.ruleStorage.sort(this.getRuleComparator());
    }

    @Override
    void addRuleDescriptors(List<KnowledgeRule> newRules) {
        this.deployRules(newRules, true);
    }

    @Override
    public void setRuleComparator(Comparator<Rule> ruleComparator) {
        super.setRuleComparator(ruleComparator);
        this.reSortRules();
    }

    @Override
    public final RuntimeRule getRule(String name) {
        return (RuntimeRule)this.ruleStorage.get(name);
    }

    @Override
    public List<RuntimeRule> getRules() {
        return Collections.unmodifiableList(this.ruleStorage.getList());
    }
}

