/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.runtime;

import java.util.Set;
import java.util.stream.Stream;
import org.evrete.KnowledgeService;
import org.evrete.api.Copyable;
import org.evrete.api.LhsField;
import org.evrete.api.RuntimeContext;
import org.evrete.api.Type;
import org.evrete.api.TypeField;
import org.evrete.collections.ForkingArrayMap;
import org.evrete.runtime.AbstractRuntimeBase;
import org.evrete.runtime.ActiveEvaluatorGenerator;
import org.evrete.runtime.ActiveField;
import org.evrete.runtime.ActiveType;
import org.evrete.runtime.ActiveTypeGenerator;
import org.evrete.runtime.AlphaAddress;
import org.evrete.runtime.DefaultFactHandle;
import org.evrete.runtime.DefaultLhsBuilder;
import org.evrete.runtime.FactType;
import org.evrete.runtime.TypeAlphaConditions;
import org.evrete.runtime.evaluation.DefaultEvaluatorHandle;

abstract class AbstractRuntimeMeta<C extends RuntimeContext<C>>
extends AbstractRuntimeBase<C> {
    private final ActiveEvaluatorGenerator evaluatorGenerator;
    private final ActiveTypeGenerator activeTypeGenerator;
    private final AlphaAddressIndexer alphaAddressIndexer;

    AbstractRuntimeMeta(KnowledgeService service) {
        super(service);
        this.evaluatorGenerator = new ActiveEvaluatorGenerator(service.getExecutor());
        this.activeTypeGenerator = new ActiveTypeGenerator();
        this.alphaAddressIndexer = new AlphaAddressIndexer();
    }

    AbstractRuntimeMeta(AbstractRuntimeMeta<?> parent) {
        super(parent);
        this.evaluatorGenerator = parent.evaluatorGenerator.copyOf();
        this.activeTypeGenerator = parent.activeTypeGenerator.copyOf();
        this.alphaAddressIndexer = parent.alphaAddressIndexer.copyOf();
    }

    @Override
    public ActiveEvaluatorGenerator getEvaluatorsContext() {
        return this.evaluatorGenerator;
    }

    ActiveField getCreateActiveField(TypeField field) {
        return ((ActiveType)this.activeTypeGenerator.getOrCreateEntry(field.getDeclaringType()).getValue()).getCreateActiveField(field);
    }

    ActiveType getCreateIndexedType(Type<?> type) {
        return (ActiveType)this.activeTypeGenerator.getOrCreateEntry(type).getValue();
    }

    AlphaAddress getCreateAlphaAddress(TypeAlphaConditions alphaConditions) {
        return (AlphaAddress)this.alphaAddressIndexer.getOrCreateEntry(alphaConditions).getValue();
    }

    FactType buildFactType(DefaultLhsBuilder.Fact lhsFact, Set<DefaultEvaluatorHandle> alphaHandles) {
        ActiveType activeType = this.getCreateIndexedType(lhsFact.getType());
        TypeAlphaConditions indexedAlphaConditions = activeType.getCreateAlphaConditions(alphaHandles);
        AlphaAddress alphaAddress = this.getCreateAlphaAddress(indexedAlphaConditions);
        activeType.registerAlphaAddress(alphaAddress);
        return new FactType(lhsFact, activeType, alphaAddress);
    }

    Stream<ActiveType> activeTypes() {
        return this.activeTypeGenerator.values();
    }

    ActiveType getActiveType(DefaultFactHandle handle) {
        return this.getActiveType(handle.getType());
    }

    ActiveType getActiveType(ActiveType.Idx id) {
        return (ActiveType)this.activeTypeGenerator.get(id);
    }

    LhsField.Array<String, ActiveField> toActiveFields(LhsField.Array<String, TypeField> fields) {
        return fields.transform(f -> new LhsField(f, this.getCreateActiveField((TypeField)f.field())));
    }

    private static class AlphaAddressIndexer
    extends ForkingArrayMap<TypeAlphaConditions, TypeAlphaConditions, AlphaAddress, AlphaAddress>
    implements Copyable<AlphaAddressIndexer> {
        AlphaAddressIndexer() {
            super((T set) -> set);
        }

        private AlphaAddressIndexer(AlphaAddressIndexer other) {
            super(other);
        }

        @Override
        public AlphaAddressIndexer copyOf() {
            return new AlphaAddressIndexer(this);
        }

        @Override
        protected AlphaAddress generateKey(TypeAlphaConditions value, int index) {
            return new AlphaAddress(index, value);
        }

        @Override
        protected AlphaAddress generateValue(AlphaAddress idx, TypeAlphaConditions value) {
            return idx;
        }
    }
}

